/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DatabaseLFTagPolicyAndPermissions;
import software.amazon.awssdk.services.dataexchange.model.TableLFTagPolicyAndPermissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportAssetsFromLakeFormationTagPolicyRequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportAssetsFromLakeFormationTagPolicyRequestDetails> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::catalogId)).setter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<DatabaseLFTagPolicyAndPermissions> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Database").getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::database)).setter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.setter(Builder::database)).constructor(DatabaseLFTagPolicyAndPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<TableLFTagPolicyAndPermissions> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::table)).setter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.setter(Builder::table)).constructor(TableLFTagPolicyAndPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::roleArn)).setter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::dataSetId)).setter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.getter(ImportAssetsFromLakeFormationTagPolicyRequestDetails::revisionId)).setter(ImportAssetsFromLakeFormationTagPolicyRequestDetails.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_FIELD, TABLE_FIELD, ROLE_ARN_FIELD, DATA_SET_ID_FIELD, REVISION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final DatabaseLFTagPolicyAndPermissions database;
    private final TableLFTagPolicyAndPermissions table;
    private final String roleArn;
    private final String dataSetId;
    private final String revisionId;

    private ImportAssetsFromLakeFormationTagPolicyRequestDetails(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.database = builder.database;
        this.table = builder.table;
        this.roleArn = builder.roleArn;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final DatabaseLFTagPolicyAndPermissions database() {
        return this.database;
    }

    public final TableLFTagPolicyAndPermissions table() {
        return this.table;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetsFromLakeFormationTagPolicyRequestDetails)) {
            return false;
        }
        ImportAssetsFromLakeFormationTagPolicyRequestDetails other = (ImportAssetsFromLakeFormationTagPolicyRequestDetails)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"ImportAssetsFromLakeFormationTagPolicyRequestDetails").add("CatalogId", (Object)this.catalogId()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("RoleArn", (Object)this.roleArn()).add("DataSetId", (Object)this.dataSetId()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetsFromLakeFormationTagPolicyRequestDetails, T> g) {
        return obj -> g.apply((ImportAssetsFromLakeFormationTagPolicyRequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private DatabaseLFTagPolicyAndPermissions database;
        private TableLFTagPolicyAndPermissions table;
        private String roleArn;
        private String dataSetId;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetsFromLakeFormationTagPolicyRequestDetails model) {
            this.catalogId(model.catalogId);
            this.database(model.database);
            this.table(model.table);
            this.roleArn(model.roleArn);
            this.dataSetId(model.dataSetId);
            this.revisionId(model.revisionId);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final DatabaseLFTagPolicyAndPermissions.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseLFTagPolicyAndPermissions.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseLFTagPolicyAndPermissions database) {
            this.database = database;
            return this;
        }

        public final TableLFTagPolicyAndPermissions.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(TableLFTagPolicyAndPermissions.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(TableLFTagPolicyAndPermissions table) {
            this.table = table;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public ImportAssetsFromLakeFormationTagPolicyRequestDetails build() {
            return new ImportAssetsFromLakeFormationTagPolicyRequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportAssetsFromLakeFormationTagPolicyRequestDetails> {
        public Builder catalogId(String var1);

        public Builder database(DatabaseLFTagPolicyAndPermissions var1);

        default public Builder database(Consumer<DatabaseLFTagPolicyAndPermissions.Builder> database) {
            return this.database((DatabaseLFTagPolicyAndPermissions)((DatabaseLFTagPolicyAndPermissions.Builder)DatabaseLFTagPolicyAndPermissions.builder().applyMutation(database)).build());
        }

        public Builder table(TableLFTagPolicyAndPermissions var1);

        default public Builder table(Consumer<TableLFTagPolicyAndPermissions.Builder> table) {
            return this.table((TableLFTagPolicyAndPermissions)((TableLFTagPolicyAndPermissions.Builder)TableLFTagPolicyAndPermissions.builder().applyMutation(table)).build());
        }

        public Builder roleArn(String var1);

        public Builder dataSetId(String var1);

        public Builder revisionId(String var1);
    }
}

