/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the operation to be performed by the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportRevisionsToS3RequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportRevisionsToS3RequestDetails.Builder, ExportRevisionsToS3RequestDetails> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ExportRevisionsToS3RequestDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField
            .<ExportServerSideEncryption> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(ExportRevisionsToS3RequestDetails::encryption)).setter(setter(Builder::encryption))
            .constructor(ExportServerSideEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final SdkField<List<RevisionDestinationEntry>> REVISION_DESTINATIONS_FIELD = SdkField
            .<List<RevisionDestinationEntry>> builder(MarshallingType.LIST)
            .memberName("RevisionDestinations")
            .getter(getter(ExportRevisionsToS3RequestDetails::revisionDestinations))
            .setter(setter(Builder::revisionDestinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionDestinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RevisionDestinationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RevisionDestinationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            ENCRYPTION_FIELD, REVISION_DESTINATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private final ExportServerSideEncryption encryption;

    private final List<RevisionDestinationEntry> revisionDestinations;

    private ExportRevisionsToS3RequestDetails(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.encryption = builder.encryption;
        this.revisionDestinations = builder.revisionDestinations;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this export job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this export job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * Encryption configuration for the export job.
     * </p>
     * 
     * @return Encryption configuration for the export job.
     */
    public final ExportServerSideEncryption encryption() {
        return encryption;
    }

    /**
     * Returns true if the RevisionDestinations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRevisionDestinations() {
        return revisionDestinations != null && !(revisionDestinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination for the revision.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRevisionDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination for the revision.
     */
    public final List<RevisionDestinationEntry> revisionDestinations() {
        return revisionDestinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(hasRevisionDestinations() ? revisionDestinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportRevisionsToS3RequestDetails)) {
            return false;
        }
        ExportRevisionsToS3RequestDetails other = (ExportRevisionsToS3RequestDetails) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(encryption(), other.encryption())
                && hasRevisionDestinations() == other.hasRevisionDestinations()
                && Objects.equals(revisionDestinations(), other.revisionDestinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportRevisionsToS3RequestDetails").add("DataSetId", dataSetId())
                .add("Encryption", encryption())
                .add("RevisionDestinations", hasRevisionDestinations() ? revisionDestinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "RevisionDestinations":
            return Optional.ofNullable(clazz.cast(revisionDestinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportRevisionsToS3RequestDetails, T> g) {
        return obj -> g.apply((ExportRevisionsToS3RequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportRevisionsToS3RequestDetails> {
        /**
         * <p>
         * The unique identifier for the data set associated with this export job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * Encryption configuration for the export job.
         * </p>
         * 
         * @param encryption
         *        Encryption configuration for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(ExportServerSideEncryption encryption);

        /**
         * <p>
         * Encryption configuration for the export job.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportServerSideEncryption.Builder} avoiding the
         * need to create one manually via {@link ExportServerSideEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportServerSideEncryption.Builder#build()} is called immediately
         * and its result is passed to {@link #encryption(ExportServerSideEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link ExportServerSideEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(ExportServerSideEncryption)
         */
        default Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return encryption(ExportServerSideEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * <p>
         * The destination for the revision.
         * </p>
         * 
         * @param revisionDestinations
         *        The destination for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDestinations(Collection<RevisionDestinationEntry> revisionDestinations);

        /**
         * <p>
         * The destination for the revision.
         * </p>
         * 
         * @param revisionDestinations
         *        The destination for the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDestinations(RevisionDestinationEntry... revisionDestinations);

        /**
         * <p>
         * The destination for the revision.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RevisionDestinationEntry>.Builder} avoiding
         * the need to create one manually via {@link List<RevisionDestinationEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RevisionDestinationEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #revisionDestinations(List<RevisionDestinationEntry>)}.
         * 
         * @param revisionDestinations
         *        a consumer that will call methods on {@link List<RevisionDestinationEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionDestinations(List<RevisionDestinationEntry>)
         */
        Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder>... revisionDestinations);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private ExportServerSideEncryption encryption;

        private List<RevisionDestinationEntry> revisionDestinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportRevisionsToS3RequestDetails model) {
            dataSetId(model.dataSetId);
            encryption(model.encryption);
            revisionDestinations(model.revisionDestinations);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<RevisionDestinationEntry.Builder> getRevisionDestinations() {
            if (revisionDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return revisionDestinations != null ? revisionDestinations.stream().map(RevisionDestinationEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisionDestinations(Collection<RevisionDestinationEntry> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copy(revisionDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(RevisionDestinationEntry... revisionDestinations) {
            revisionDestinations(Arrays.asList(revisionDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionDestinations(Consumer<RevisionDestinationEntry.Builder>... revisionDestinations) {
            revisionDestinations(Stream.of(revisionDestinations)
                    .map(c -> RevisionDestinationEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisionDestinations(Collection<RevisionDestinationEntry.BuilderImpl> revisionDestinations) {
            this.revisionDestinations = ListOfRevisionDestinationEntryCopier.copyFromBuilder(revisionDestinations);
        }

        @Override
        public ExportRevisionsToS3RequestDetails build() {
            return new ExportRevisionsToS3RequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
