/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LimitName {
    PRODUCTS_PER_ACCOUNT("Products per account"),
    DATA_SETS_PER_ACCOUNT("Data sets per account"),
    DATA_SETS_PER_PRODUCT("Data sets per product"),
    REVISIONS_PER_DATA_SET("Revisions per data set"),
    ASSETS_PER_REVISION("Assets per revision"),
    ASSETS_PER_IMPORT_JOB_FROM_AMAZON_S3("Assets per import job from Amazon S3"),
    ASSET_PER_EXPORT_JOB_FROM_AMAZON_S3("Asset per export job from Amazon S3"),
    ASSET_SIZE_IN_GB("Asset size in GB"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_AMAZON_S3("Concurrent in progress jobs to import assets from Amazon S3"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_IMPORT_ASSETS_FROM_A_SIGNED_URL("Concurrent in progress jobs to import assets from a signed URL"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_AMAZON_S3("Concurrent in progress jobs to export assets to Amazon S3"),
    CONCURRENT_IN_PROGRESS_JOBS_TO_EXPORT_ASSETS_TO_A_SIGNED_URL("Concurrent in progress jobs to export assets to a signed URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LimitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LimitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LimitName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LimitName> knownValues() {
        return Stream.of(LimitName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

