/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the operation to be performed by the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportAssetToSignedUrlRequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportAssetToSignedUrlRequestDetails.Builder, ExportAssetToSignedUrlRequestDetails> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportAssetToSignedUrlRequestDetails::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetId").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportAssetToSignedUrlRequestDetails::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportAssetToSignedUrlRequestDetails::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            DATA_SET_ID_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String dataSetId;

    private final String revisionId;

    private ExportAssetToSignedUrlRequestDetails(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The unique identifier for the asset that is exported to a signed URL.
     * </p>
     * 
     * @return The unique identifier for the asset that is exported to a signed URL.
     */
    public String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this export job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this export job.
     */
    public String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this export request.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this export request.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAssetToSignedUrlRequestDetails)) {
            return false;
        }
        ExportAssetToSignedUrlRequestDetails other = (ExportAssetToSignedUrlRequestDetails) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportAssetToSignedUrlRequestDetails").add("AssetId", assetId()).add("DataSetId", dataSetId())
                .add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportAssetToSignedUrlRequestDetails, T> g) {
        return obj -> g.apply((ExportAssetToSignedUrlRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportAssetToSignedUrlRequestDetails> {
        /**
         * <p>
         * The unique identifier for the asset that is exported to a signed URL.
         * </p>
         * 
         * @param assetId
         *        The unique identifier for the asset that is exported to a signed URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The unique identifier for the data set associated with this export job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The unique identifier for the revision associated with this export request.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String dataSetId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportAssetToSignedUrlRequestDetails model) {
            assetId(model.assetId);
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public ExportAssetToSignedUrlRequestDetails build() {
            return new ExportAssetToSignedUrlRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
