/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.ListOfRevisionEntryCopier;
import software.amazon.awssdk.services.dataexchange.model.RevisionEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSetRevisionsResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, ListDataSetRevisionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDataSetRevisionsResponse.getter(ListDataSetRevisionsResponse::nextToken)).setter(ListDataSetRevisionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RevisionEntry>> REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDataSetRevisionsResponse.getter(ListDataSetRevisionsResponse::revisions)).setter(ListDataSetRevisionsResponse.setter(Builder::revisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REVISIONS_FIELD));
    private final String nextToken;
    private final List<RevisionEntry> revisions;

    private ListDataSetRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.revisions = builder.revisions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<RevisionEntry> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSetRevisionsResponse)) {
            return false;
        }
        ListDataSetRevisionsResponse other = (ListDataSetRevisionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.revisions(), other.revisions());
    }

    public String toString() {
        return ToString.builder((String)"ListDataSetRevisionsResponse").add("NextToken", (Object)this.nextToken()).add("Revisions", this.revisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Revisions": {
                return Optional.ofNullable(clazz.cast(this.revisions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSetRevisionsResponse, T> g) {
        return obj -> g.apply((ListDataSetRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RevisionEntry> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSetRevisionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.revisions(model.revisions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RevisionEntry.Builder> getRevisions() {
            return this.revisions != null ? (Collection)this.revisions.stream().map(RevisionEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder revisions(Collection<RevisionEntry> revisions) {
            this.revisions = ListOfRevisionEntryCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionEntry ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionEntry.Builder> ... revisions) {
            this.revisions(Stream.of(revisions).map(c -> (RevisionEntry)((RevisionEntry.Builder)RevisionEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRevisions(Collection<RevisionEntry.BuilderImpl> revisions) {
            this.revisions = ListOfRevisionEntryCopier.copyFromBuilder(revisions);
        }

        @Override
        public ListDataSetRevisionsResponse build() {
            return new ListDataSetRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSetRevisionsResponse> {
        public Builder nextToken(String var1);

        public Builder revisions(Collection<RevisionEntry> var1);

        public Builder revisions(RevisionEntry ... var1);

        public Builder revisions(Consumer<RevisionEntry.Builder> ... var1);
    }
}

