/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DataBrewRequest;
import software.amazon.awssdk.services.databrew.model.JobNameListCopier;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScheduleRequest
extends DataBrewRequest
implements ToCopyableBuilder<Builder, CreateScheduleRequest> {
    private static final SdkField<List<String>> JOB_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobNames").getter(CreateScheduleRequest.getter(CreateScheduleRequest::jobNames)).setter(CreateScheduleRequest.setter(Builder::jobNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CronExpression").getter(CreateScheduleRequest.getter(CreateScheduleRequest::cronExpression)).setter(CreateScheduleRequest.setter(Builder::cronExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateScheduleRequest.getter(CreateScheduleRequest::tags)).setter(CreateScheduleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateScheduleRequest.getter(CreateScheduleRequest::name)).setter(CreateScheduleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAMES_FIELD, CRON_EXPRESSION_FIELD, TAGS_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScheduleRequest.memberNameToFieldInitializer();
    private final List<String> jobNames;
    private final String cronExpression;
    private final Map<String, String> tags;
    private final String name;

    private CreateScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.jobNames = builder.jobNames;
        this.cronExpression = builder.cronExpression;
        this.tags = builder.tags;
        this.name = builder.name;
    }

    public final boolean hasJobNames() {
        return this.jobNames != null && !(this.jobNames instanceof SdkAutoConstructList);
    }

    public final List<String> jobNames() {
        return this.jobNames;
    }

    public final String cronExpression() {
        return this.cronExpression;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobNames() ? this.jobNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduleRequest)) {
            return false;
        }
        CreateScheduleRequest other = (CreateScheduleRequest)((Object)obj);
        return this.hasJobNames() == other.hasJobNames() && Objects.equals(this.jobNames(), other.jobNames()) && Objects.equals(this.cronExpression(), other.cronExpression()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScheduleRequest").add("JobNames", this.hasJobNames() ? this.jobNames() : null).add("CronExpression", (Object)this.cronExpression()).add("Tags", this.hasTags() ? this.tags() : null).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobNames": {
                return Optional.ofNullable(clazz.cast(this.jobNames()));
            }
            case "CronExpression": {
                return Optional.ofNullable(clazz.cast(this.cronExpression()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobNames", JOB_NAMES_FIELD);
        map.put("CronExpression", CRON_EXPRESSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduleRequest, T> g) {
        return obj -> g.apply((CreateScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewRequest.BuilderImpl
    implements Builder {
        private List<String> jobNames = DefaultSdkAutoConstructList.getInstance();
        private String cronExpression;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduleRequest model) {
            super(model);
            this.jobNames(model.jobNames);
            this.cronExpression(model.cronExpression);
            this.tags(model.tags);
            this.name(model.name);
        }

        public final Collection<String> getJobNames() {
            if (this.jobNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobNames;
        }

        public final void setJobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
        }

        @Override
        public final Builder jobNames(Collection<String> jobNames) {
            this.jobNames = JobNameListCopier.copy(jobNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobNames(String ... jobNames) {
            this.jobNames(Arrays.asList(jobNames));
            return this;
        }

        public final String getCronExpression() {
            return this.cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduleRequest build() {
            return new CreateScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataBrewRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScheduleRequest> {
        public Builder jobNames(Collection<String> var1);

        public Builder jobNames(String ... var1);

        public Builder cronExpression(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

