/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.Project;

final class ProjectListCopier {
    ProjectListCopier() {
    }

    static List<Project> copy(Collection<? extends Project> projectListParam) {
        Object list;
        if (projectListParam == null || projectListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(projectListParam.size());
            projectListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Project> copyFromBuilder(Collection<? extends Project.Builder> projectListParam) {
        Object list;
        if (projectListParam == null || projectListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(projectListParam.size());
            projectListParam.forEach(entry -> {
                Project member = entry == null ? null : (Project)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Project.Builder> copyToBuilder(Collection<? extends Project> projectListParam) {
        Object list;
        if (projectListParam == null || projectListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(projectListParam.size());
            projectListParam.forEach(entry -> {
                Project.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

