/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one or more actions to be performed on a DataBrew dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recipe implements SdkPojo, Serializable, ToCopyableBuilder<Recipe.Builder, Recipe> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(Recipe::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Recipe::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(Recipe::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(Recipe::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(Recipe::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> PUBLISHED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishedBy").getter(getter(Recipe::publishedBy)).setter(setter(Builder::publishedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedBy").build()).build();

    private static final SdkField<Instant> PUBLISHED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PublishedDate").getter(getter(Recipe::publishedDate)).setter(setter(Builder::publishedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Recipe::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Recipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Recipe::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<RecipeStep>> STEPS_FIELD = SdkField
            .<List<RecipeStep>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(Recipe::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecipeStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecipeStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Recipe::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RECIPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipeVersion").getter(getter(Recipe::recipeVersion)).setter(setter(Builder::recipeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            CREATE_DATE_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, PROJECT_NAME_FIELD, PUBLISHED_BY_FIELD,
            PUBLISHED_DATE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, RESOURCE_ARN_FIELD, STEPS_FIELD, TAGS_FIELD,
            RECIPE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createdBy;

    private final Instant createDate;

    private final String lastModifiedBy;

    private final Instant lastModifiedDate;

    private final String projectName;

    private final String publishedBy;

    private final Instant publishedDate;

    private final String description;

    private final String name;

    private final String resourceArn;

    private final List<RecipeStep> steps;

    private final Map<String, String> tags;

    private final String recipeVersion;

    private Recipe(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.projectName = builder.projectName;
        this.publishedBy = builder.publishedBy;
        this.publishedDate = builder.publishedDate;
        this.description = builder.description;
        this.name = builder.name;
        this.resourceArn = builder.resourceArn;
        this.steps = builder.steps;
        this.tags = builder.tags;
        this.recipeVersion = builder.recipeVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who created the recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who created the recipe.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the recipe was created.
     * </p>
     * 
     * @return The date and time that the recipe was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last modified the recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last modified the recipe.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The last modification date and time of the recipe.
     * </p>
     * 
     * @return The last modification date and time of the recipe.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The name of the project that the recipe is associated with.
     * </p>
     * 
     * @return The name of the project that the recipe is associated with.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who published the recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who published the recipe.
     */
    public final String publishedBy() {
        return publishedBy;
    }

    /**
     * <p>
     * The date and time when the recipe was published.
     * </p>
     * 
     * @return The date and time when the recipe was published.
     */
    public final Instant publishedDate() {
        return publishedDate;
    }

    /**
     * <p>
     * The description of the recipe.
     * </p>
     * 
     * @return The description of the recipe.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique name for the recipe.
     * </p>
     * 
     * @return The unique name for the recipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the recipe.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of steps that are defined by the recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return A list of steps that are defined by the recipe.
     */
    public final List<RecipeStep> steps() {
        return steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags that have been applied to the recipe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata tags that have been applied to the recipe.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier for the version for the recipe. Must be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand for major and minor version numbers.
     * The maximum length of each is 6 digits, and neither can be negative values. Both <code>X</code> and
     * <code>Y</code> are required, and "0.0" isn't a valid version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST_WORKING</code> - the most recent valid version being developed in a DataBrew project.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LATEST_PUBLISHED</code> - the most recent published version.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the version for the recipe. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand for major and minor version
     *         numbers. The maximum length of each is 6 digits, and neither can be negative values. Both <code>X</code>
     *         and <code>Y</code> are required, and "0.0" isn't a valid version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST_WORKING</code> - the most recent valid version being developed in a DataBrew project.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LATEST_PUBLISHED</code> - the most recent published version.
     *         </p>
     *         </li>
     */
    public final String recipeVersion() {
        return recipeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(publishedBy());
        hashCode = 31 * hashCode + Objects.hashCode(publishedDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recipeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(projectName(), other.projectName()) && Objects.equals(publishedBy(), other.publishedBy())
                && Objects.equals(publishedDate(), other.publishedDate()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(resourceArn(), other.resourceArn())
                && hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(recipeVersion(), other.recipeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recipe").add("CreatedBy", createdBy()).add("CreateDate", createDate())
                .add("LastModifiedBy", lastModifiedBy()).add("LastModifiedDate", lastModifiedDate())
                .add("ProjectName", projectName()).add("PublishedBy", publishedBy()).add("PublishedDate", publishedDate())
                .add("Description", description()).add("Name", name()).add("ResourceArn", resourceArn())
                .add("Steps", hasSteps() ? steps() : null).add("Tags", hasTags() ? tags() : null)
                .add("RecipeVersion", recipeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "PublishedBy":
            return Optional.ofNullable(clazz.cast(publishedBy()));
        case "PublishedDate":
            return Optional.ofNullable(clazz.cast(publishedDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RecipeVersion":
            return Optional.ofNullable(clazz.cast(recipeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recipe, T> g) {
        return obj -> g.apply((Recipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recipe> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who created the recipe.
         * </p>
         * 
         * @param createdBy
         *        The Amazon Resource Name (ARN) of the user who created the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the recipe was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the recipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last modified the recipe.
         * </p>
         * 
         * @param lastModifiedBy
         *        The Amazon Resource Name (ARN) of the user who last modified the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The last modification date and time of the recipe.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last modification date and time of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The name of the project that the recipe is associated with.
         * </p>
         * 
         * @param projectName
         *        The name of the project that the recipe is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who published the recipe.
         * </p>
         * 
         * @param publishedBy
         *        The Amazon Resource Name (ARN) of the user who published the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishedBy(String publishedBy);

        /**
         * <p>
         * The date and time when the recipe was published.
         * </p>
         * 
         * @param publishedDate
         *        The date and time when the recipe was published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishedDate(Instant publishedDate);

        /**
         * <p>
         * The description of the recipe.
         * </p>
         * 
         * @param description
         *        The description of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique name for the recipe.
         * </p>
         * 
         * @param name
         *        The unique name for the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the recipe.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) for the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * A list of steps that are defined by the recipe.
         * </p>
         * 
         * @param steps
         *        A list of steps that are defined by the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<RecipeStep> steps);

        /**
         * <p>
         * A list of steps that are defined by the recipe.
         * </p>
         * 
         * @param steps
         *        A list of steps that are defined by the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(RecipeStep... steps);

        /**
         * <p>
         * A list of steps that are defined by the recipe.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databrew.model.RecipeStep.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.databrew.model.RecipeStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databrew.model.RecipeStep.Builder#build()} is called immediately and
         * its result is passed to {@link #steps(List<RecipeStep>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databrew.model.RecipeStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<RecipeStep>)
         */
        Builder steps(Consumer<RecipeStep.Builder>... steps);

        /**
         * <p>
         * Metadata tags that have been applied to the recipe.
         * </p>
         * 
         * @param tags
         *        Metadata tags that have been applied to the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The identifier for the version for the recipe. Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand for major and minor version
         * numbers. The maximum length of each is 6 digits, and neither can be negative values. Both <code>X</code> and
         * <code>Y</code> are required, and "0.0" isn't a valid version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST_WORKING</code> - the most recent valid version being developed in a DataBrew project.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LATEST_PUBLISHED</code> - the most recent published version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param recipeVersion
         *        The identifier for the version for the recipe. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Numeric version (<code>X.Y</code>) - <code>X</code> and <code>Y</code> stand for major and minor
         *        version numbers. The maximum length of each is 6 digits, and neither can be negative values. Both
         *        <code>X</code> and <code>Y</code> are required, and "0.0" isn't a valid version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST_WORKING</code> - the most recent valid version being developed in a DataBrew project.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LATEST_PUBLISHED</code> - the most recent published version.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeVersion(String recipeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String createdBy;

        private Instant createDate;

        private String lastModifiedBy;

        private Instant lastModifiedDate;

        private String projectName;

        private String publishedBy;

        private Instant publishedDate;

        private String description;

        private String name;

        private String resourceArn;

        private List<RecipeStep> steps = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String recipeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Recipe model) {
            createdBy(model.createdBy);
            createDate(model.createDate);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            projectName(model.projectName);
            publishedBy(model.publishedBy);
            publishedDate(model.publishedDate);
            description(model.description);
            name(model.name);
            resourceArn(model.resourceArn);
            steps(model.steps);
            tags(model.tags);
            recipeVersion(model.recipeVersion);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getPublishedBy() {
            return publishedBy;
        }

        public final void setPublishedBy(String publishedBy) {
            this.publishedBy = publishedBy;
        }

        @Override
        public final Builder publishedBy(String publishedBy) {
            this.publishedBy = publishedBy;
            return this;
        }

        public final Instant getPublishedDate() {
            return publishedDate;
        }

        public final void setPublishedDate(Instant publishedDate) {
            this.publishedDate = publishedDate;
        }

        @Override
        public final Builder publishedDate(Instant publishedDate) {
            this.publishedDate = publishedDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<RecipeStep.Builder> getSteps() {
            List<RecipeStep.Builder> result = RecipeStepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<RecipeStep.BuilderImpl> steps) {
            this.steps = RecipeStepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<RecipeStep> steps) {
            this.steps = RecipeStepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(RecipeStep... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<RecipeStep.Builder>... steps) {
            steps(Stream.of(steps).map(c -> RecipeStep.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRecipeVersion() {
            return recipeVersion;
        }

        public final void setRecipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
        }

        @Override
        public final Builder recipeVersion(String recipeVersion) {
            this.recipeVersion = recipeVersion;
            return this;
        }

        @Override
        public Recipe build() {
            return new Recipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
