/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProjectSessionResponse extends DataBrewResponse implements
        ToCopyableBuilder<StartProjectSessionResponse.Builder, StartProjectSessionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartProjectSessionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLIENT_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientSessionId").getter(getter(StartProjectSessionResponse::clientSessionId))
            .setter(setter(Builder::clientSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLIENT_SESSION_ID_FIELD));

    private final String name;

    private final String clientSessionId;

    private StartProjectSessionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientSessionId = builder.clientSessionId;
    }

    /**
     * <p>
     * The name of the project to be acted upon.
     * </p>
     * 
     * @return The name of the project to be acted upon.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A system-generated identifier for the session.
     * </p>
     * 
     * @return A system-generated identifier for the session.
     */
    public final String clientSessionId() {
        return clientSessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientSessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProjectSessionResponse)) {
            return false;
        }
        StartProjectSessionResponse other = (StartProjectSessionResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(clientSessionId(), other.clientSessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProjectSessionResponse").add("Name", name()).add("ClientSessionId", clientSessionId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ClientSessionId":
            return Optional.ofNullable(clazz.cast(clientSessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartProjectSessionResponse, T> g) {
        return obj -> g.apply((StartProjectSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartProjectSessionResponse> {
        /**
         * <p>
         * The name of the project to be acted upon.
         * </p>
         * 
         * @param name
         *        The name of the project to be acted upon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A system-generated identifier for the session.
         * </p>
         * 
         * @param clientSessionId
         *        A system-generated identifier for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSessionId(String clientSessionId);
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private String name;

        private String clientSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProjectSessionResponse model) {
            super(model);
            name(model.name);
            clientSessionId(model.clientSessionId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClientSessionId() {
            return clientSessionId;
        }

        @Override
        public final Builder clientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
            return this;
        }

        public final void setClientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
        }

        @Override
        public StartProjectSessionResponse build() {
            return new StartProjectSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
