/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends DataBrewResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(DescribeDatasetResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(DescribeDatasetResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeDatasetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField
            .<FormatOptions> builder(MarshallingType.SDK_POJO).memberName("FormatOptions")
            .getter(getter(DescribeDatasetResponse::formatOptions)).setter(setter(Builder::formatOptions))
            .constructor(FormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatOptions").build()).build();

    private static final SdkField<Input> INPUT_FIELD = SdkField.<Input> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(DescribeDatasetResponse::input)).setter(setter(Builder::input)).constructor(Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(DescribeDatasetResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(DescribeDatasetResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(DescribeDatasetResponse::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeDatasetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeDatasetResponse::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            CREATE_DATE_FIELD, NAME_FIELD, FORMAT_OPTIONS_FIELD, INPUT_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_BY_FIELD,
            SOURCE_FIELD, TAGS_FIELD, RESOURCE_ARN_FIELD));

    private final String createdBy;

    private final Instant createDate;

    private final String name;

    private final FormatOptions formatOptions;

    private final Input input;

    private final Instant lastModifiedDate;

    private final String lastModifiedBy;

    private final String source;

    private final Map<String, String> tags;

    private final String resourceArn;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.createDate = builder.createDate;
        this.name = builder.name;
        this.formatOptions = builder.formatOptions;
        this.input = builder.input;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.source = builder.source;
        this.tags = builder.tags;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The identifier (user name) of the user who created the dataset.
     * </p>
     * 
     * @return The identifier (user name) of the user who created the dataset.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the dataset was created.
     * </p>
     * 
     * @return The date and time that the dataset was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the FormatOptions property for this object.
     * 
     * @return The value of the FormatOptions property for this object.
     */
    public final FormatOptions formatOptions() {
        return formatOptions;
    }

    /**
     * Returns the value of the Input property for this object.
     * 
     * @return The value of the Input property for this object.
     */
    public final Input input() {
        return input;
    }

    /**
     * <p>
     * The date and time that the dataset was last modified.
     * </p>
     * 
     * @return The date and time that the dataset was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The identifier (user name) of the user who last modified the dataset.
     * </p>
     * 
     * @return The identifier (user name) of the user who last modified the dataset.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
     * @see Source
     */
    public final Source source() {
        return Source.fromValue(source);
    }

    /**
     * <p>
     * The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
     * @see Source
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags associated with this dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata tags associated with this dataset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(name(), other.name()) && Objects.equals(formatOptions(), other.formatOptions())
                && Objects.equals(input(), other.input()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(sourceAsString(), other.sourceAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("CreatedBy", createdBy()).add("CreateDate", createDate())
                .add("Name", name()).add("FormatOptions", formatOptions()).add("Input", input())
                .add("LastModifiedDate", lastModifiedDate()).add("LastModifiedBy", lastModifiedBy())
                .add("Source", sourceAsString()).add("Tags", hasTags() ? tags() : null).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FormatOptions":
            return Optional.ofNullable(clazz.cast(formatOptions()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The identifier (user name) of the user who created the dataset.
         * </p>
         * 
         * @param createdBy
         *        The identifier (user name) of the user who created the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the dataset was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param name
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the FormatOptions property for this object.
         *
         * @param formatOptions
         *        The new value for the FormatOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatOptions(FormatOptions formatOptions);

        /**
         * Sets the value of the FormatOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link FormatOptions.Builder} avoiding the need to
         * create one manually via {@link FormatOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link FormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #formatOptions(FormatOptions)}.
         * 
         * @param formatOptions
         *        a consumer that will call methods on {@link FormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatOptions(FormatOptions)
         */
        default Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return formatOptions(FormatOptions.builder().applyMutation(formatOptions).build());
        }

        /**
         * Sets the value of the Input property for this object.
         *
         * @param input
         *        The new value for the Input property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);

        /**
         * Sets the value of the Input property for this object.
         *
         * This is a convenience that creates an instance of the {@link Input.Builder} avoiding the need to create one
         * manually via {@link Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link Input.Builder#build()} is called immediately and its result is
         * passed to {@link #input(Input)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(Input)
         */
        default Builder input(Consumer<Input.Builder> input) {
            return input(Input.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The date and time that the dataset was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time that the dataset was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The identifier (user name) of the user who last modified the dataset.
         * </p>
         * 
         * @param lastModifiedBy
         *        The identifier (user name) of the user who last modified the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
         * </p>
         * 
         * @param source
         *        The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(String source);

        /**
         * <p>
         * The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
         * </p>
         * 
         * @param source
         *        The location of the data for this dataset, Amazon S3 or the AWS Glue Data Catalog.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(Source source);

        /**
         * <p>
         * Metadata tags associated with this dataset.
         * </p>
         * 
         * @param tags
         *        Metadata tags associated with this dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl extends DataBrewResponse.BuilderImpl implements Builder {
        private String createdBy;

        private Instant createDate;

        private String name;

        private FormatOptions formatOptions;

        private Input input;

        private Instant lastModifiedDate;

        private String lastModifiedBy;

        private String source;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            createdBy(model.createdBy);
            createDate(model.createDate);
            name(model.name);
            formatOptions(model.formatOptions);
            input(model.input);
            lastModifiedDate(model.lastModifiedDate);
            lastModifiedBy(model.lastModifiedBy);
            source(model.source);
            tags(model.tags);
            resourceArn(model.resourceArn);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return formatOptions != null ? formatOptions.toBuilder() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        public final Input.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
