/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationTaskStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationTaskStats> {
    private static final SdkField<Integer> FULL_LOAD_PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReplicationTaskStats.getter(ReplicationTaskStats::fullLoadProgressPercent)).setter(ReplicationTaskStats.setter(Builder::fullLoadProgressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadProgressPercent").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ReplicationTaskStats.getter(ReplicationTaskStats::elapsedTimeMillis)).setter(ReplicationTaskStats.setter(Builder::elapsedTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeMillis").build()}).build();
    private static final SdkField<Integer> TABLES_LOADED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesLoaded)).setter(ReplicationTaskStats.setter(Builder::tablesLoaded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoaded").build()}).build();
    private static final SdkField<Integer> TABLES_LOADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesLoading)).setter(ReplicationTaskStats.setter(Builder::tablesLoading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesLoading").build()}).build();
    private static final SdkField<Integer> TABLES_QUEUED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesQueued)).setter(ReplicationTaskStats.setter(Builder::tablesQueued)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesQueued").build()}).build();
    private static final SdkField<Integer> TABLES_ERRORED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReplicationTaskStats.getter(ReplicationTaskStats::tablesErrored)).setter(ReplicationTaskStats.setter(Builder::tablesErrored)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesErrored").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULL_LOAD_PROGRESS_PERCENT_FIELD, ELAPSED_TIME_MILLIS_FIELD, TABLES_LOADED_FIELD, TABLES_LOADING_FIELD, TABLES_QUEUED_FIELD, TABLES_ERRORED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fullLoadProgressPercent;
    private final Long elapsedTimeMillis;
    private final Integer tablesLoaded;
    private final Integer tablesLoading;
    private final Integer tablesQueued;
    private final Integer tablesErrored;

    private ReplicationTaskStats(BuilderImpl builder) {
        this.fullLoadProgressPercent = builder.fullLoadProgressPercent;
        this.elapsedTimeMillis = builder.elapsedTimeMillis;
        this.tablesLoaded = builder.tablesLoaded;
        this.tablesLoading = builder.tablesLoading;
        this.tablesQueued = builder.tablesQueued;
        this.tablesErrored = builder.tablesErrored;
    }

    public Integer fullLoadProgressPercent() {
        return this.fullLoadProgressPercent;
    }

    public Long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public Integer tablesLoaded() {
        return this.tablesLoaded;
    }

    public Integer tablesLoading() {
        return this.tablesLoading;
    }

    public Integer tablesQueued() {
        return this.tablesQueued;
    }

    public Integer tablesErrored() {
        return this.tablesErrored;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadProgressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesLoading());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesQueued());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesErrored());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskStats)) {
            return false;
        }
        ReplicationTaskStats other = (ReplicationTaskStats)obj;
        return Objects.equals(this.fullLoadProgressPercent(), other.fullLoadProgressPercent()) && Objects.equals(this.elapsedTimeMillis(), other.elapsedTimeMillis()) && Objects.equals(this.tablesLoaded(), other.tablesLoaded()) && Objects.equals(this.tablesLoading(), other.tablesLoading()) && Objects.equals(this.tablesQueued(), other.tablesQueued()) && Objects.equals(this.tablesErrored(), other.tablesErrored());
    }

    public String toString() {
        return ToString.builder((String)"ReplicationTaskStats").add("FullLoadProgressPercent", (Object)this.fullLoadProgressPercent()).add("ElapsedTimeMillis", (Object)this.elapsedTimeMillis()).add("TablesLoaded", (Object)this.tablesLoaded()).add("TablesLoading", (Object)this.tablesLoading()).add("TablesQueued", (Object)this.tablesQueued()).add("TablesErrored", (Object)this.tablesErrored()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FullLoadProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.fullLoadProgressPercent()));
            }
            case "ElapsedTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeMillis()));
            }
            case "TablesLoaded": {
                return Optional.ofNullable(clazz.cast(this.tablesLoaded()));
            }
            case "TablesLoading": {
                return Optional.ofNullable(clazz.cast(this.tablesLoading()));
            }
            case "TablesQueued": {
                return Optional.ofNullable(clazz.cast(this.tablesQueued()));
            }
            case "TablesErrored": {
                return Optional.ofNullable(clazz.cast(this.tablesErrored()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskStats, T> g) {
        return obj -> g.apply((ReplicationTaskStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fullLoadProgressPercent;
        private Long elapsedTimeMillis;
        private Integer tablesLoaded;
        private Integer tablesLoading;
        private Integer tablesQueued;
        private Integer tablesErrored;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskStats model) {
            this.fullLoadProgressPercent(model.fullLoadProgressPercent);
            this.elapsedTimeMillis(model.elapsedTimeMillis);
            this.tablesLoaded(model.tablesLoaded);
            this.tablesLoading(model.tablesLoading);
            this.tablesQueued(model.tablesQueued);
            this.tablesErrored(model.tablesErrored);
        }

        public final Integer getFullLoadProgressPercent() {
            return this.fullLoadProgressPercent;
        }

        @Override
        public final Builder fullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
            return this;
        }

        public final void setFullLoadProgressPercent(Integer fullLoadProgressPercent) {
            this.fullLoadProgressPercent = fullLoadProgressPercent;
        }

        public final Long getElapsedTimeMillis() {
            return this.elapsedTimeMillis;
        }

        @Override
        public final Builder elapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public final void setElapsedTimeMillis(Long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
        }

        public final Integer getTablesLoaded() {
            return this.tablesLoaded;
        }

        @Override
        public final Builder tablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
            return this;
        }

        public final void setTablesLoaded(Integer tablesLoaded) {
            this.tablesLoaded = tablesLoaded;
        }

        public final Integer getTablesLoading() {
            return this.tablesLoading;
        }

        @Override
        public final Builder tablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
            return this;
        }

        public final void setTablesLoading(Integer tablesLoading) {
            this.tablesLoading = tablesLoading;
        }

        public final Integer getTablesQueued() {
            return this.tablesQueued;
        }

        @Override
        public final Builder tablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
            return this;
        }

        public final void setTablesQueued(Integer tablesQueued) {
            this.tablesQueued = tablesQueued;
        }

        public final Integer getTablesErrored() {
            return this.tablesErrored;
        }

        @Override
        public final Builder tablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
            return this;
        }

        public final void setTablesErrored(Integer tablesErrored) {
            this.tablesErrored = tablesErrored;
        }

        public ReplicationTaskStats build() {
            return new ReplicationTaskStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationTaskStats> {
        public Builder fullLoadProgressPercent(Integer var1);

        public Builder elapsedTimeMillis(Long var1);

        public Builder tablesLoaded(Integer var1);

        public Builder tablesLoading(Integer var1);

        public Builder tablesQueued(Integer var1);

        public Builder tablesErrored(Integer var1);
    }
}

