/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationTaskRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::replicationTaskIdentifier)).setter(CreateReplicationTaskRequest.setter(Builder::replicationTaskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::sourceEndpointArn)).setter(CreateReplicationTaskRequest.setter(Builder::sourceEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()}).build();
    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::targetEndpointArn)).setter(CreateReplicationTaskRequest.setter(Builder::targetEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::replicationInstanceArn)).setter(CreateReplicationTaskRequest.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::migrationTypeAsString)).setter(CreateReplicationTaskRequest.setter(Builder::migrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()}).build();
    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::tableMappings)).setter(CreateReplicationTaskRequest.setter(Builder::tableMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()}).build();
    private static final SdkField<String> REPLICATION_TASK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::replicationTaskSettings)).setter(CreateReplicationTaskRequest.setter(Builder::replicationTaskSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskSettings").build()}).build();
    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::cdcStartTime)).setter(CreateReplicationTaskRequest.setter(Builder::cdcStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()}).build();
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::cdcStartPosition)).setter(CreateReplicationTaskRequest.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()}).build();
    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::cdcStopPosition)).setter(CreateReplicationTaskRequest.setter(Builder::cdcStopPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateReplicationTaskRequest.getter(CreateReplicationTaskRequest::tags)).setter(CreateReplicationTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_IDENTIFIER_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD, REPLICATION_INSTANCE_ARN_FIELD, MIGRATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_TASK_SETTINGS_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD, TAGS_FIELD));
    private final String replicationTaskIdentifier;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;
    private final String replicationInstanceArn;
    private final String migrationType;
    private final String tableMappings;
    private final String replicationTaskSettings;
    private final Instant cdcStartTime;
    private final String cdcStartPosition;
    private final String cdcStopPosition;
    private final List<Tag> tags;

    private CreateReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.migrationType = builder.migrationType;
        this.tableMappings = builder.tableMappings;
        this.replicationTaskSettings = builder.replicationTaskSettings;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.tags = builder.tags;
    }

    public String replicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(this.migrationType);
    }

    public String migrationTypeAsString() {
        return this.migrationType;
    }

    public String tableMappings() {
        return this.tableMappings;
    }

    public String replicationTaskSettings() {
        return this.replicationTaskSettings;
    }

    public Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationTaskRequest)) {
            return false;
        }
        CreateReplicationTaskRequest other = (CreateReplicationTaskRequest)((Object)obj);
        return Objects.equals(this.replicationTaskIdentifier(), other.replicationTaskIdentifier()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.migrationTypeAsString(), other.migrationTypeAsString()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationTaskSettings(), other.replicationTaskSettings()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationTaskRequest").add("ReplicationTaskIdentifier", (Object)this.replicationTaskIdentifier()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("MigrationType", (Object)this.migrationTypeAsString()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationTaskSettings", (Object)this.replicationTaskSettings()).add("CdcStartTime", (Object)this.cdcStartTime()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIdentifier()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "MigrationType": {
                return Optional.ofNullable(clazz.cast(this.migrationTypeAsString()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationTaskSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskSettings()));
            }
            case "CdcStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationTaskRequest, T> g) {
        return obj -> g.apply((CreateReplicationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskIdentifier;
        private String sourceEndpointArn;
        private String targetEndpointArn;
        private String replicationInstanceArn;
        private String migrationType;
        private String tableMappings;
        private String replicationTaskSettings;
        private Instant cdcStartTime;
        private String cdcStartPosition;
        private String cdcStopPosition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationTaskRequest model) {
            super(model);
            this.replicationTaskIdentifier(model.replicationTaskIdentifier);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.migrationType(model.migrationType);
            this.tableMappings(model.tableMappings);
            this.replicationTaskSettings(model.replicationTaskSettings);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
            this.tags(model.tags);
        }

        public final String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getMigrationTypeAsString() {
            return this.migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType.toString());
            return this;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        public final String getReplicationTaskSettings() {
            return this.replicationTaskSettings;
        }

        @Override
        public final Builder replicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
            return this;
        }

        public final void setReplicationTaskSettings(String replicationTaskSettings) {
            this.replicationTaskSettings = replicationTaskSettings;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationTaskRequest build() {
            return new CreateReplicationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationTaskRequest> {
        public Builder replicationTaskIdentifier(String var1);

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder replicationInstanceArn(String var1);

        public Builder migrationType(String var1);

        public Builder migrationType(MigrationTypeValue var1);

        public Builder tableMappings(String var1);

        public Builder replicationTaskSettings(String var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

