/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMetadataModelCreationRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartMetadataModelCreationRequest.Builder, StartMetadataModelCreationRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectIdentifier")
            .getter(getter(StartMetadataModelCreationRequest::migrationProjectIdentifier))
            .setter(setter(Builder::migrationProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build())
            .build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(StartMetadataModelCreationRequest::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final SdkField<String> METADATA_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataModelName").getter(getter(StartMetadataModelCreationRequest::metadataModelName))
            .setter(setter(Builder::metadataModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelName").build()).build();

    private static final SdkField<MetadataModelProperties> PROPERTIES_FIELD = SdkField
            .<MetadataModelProperties> builder(MarshallingType.SDK_POJO).memberName("Properties")
            .getter(getter(StartMetadataModelCreationRequest::properties)).setter(setter(Builder::properties))
            .constructor(MetadataModelProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, METADATA_MODEL_NAME_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String migrationProjectIdentifier;

    private final String selectionRules;

    private final String metadataModelName;

    private final MetadataModelProperties properties;

    private StartMetadataModelCreationRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.metadataModelName = builder.metadataModelName;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The migration project name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The migration project name or Amazon Resource Name (ARN).
     */
    public final String migrationProjectIdentifier() {
        return migrationProjectIdentifier;
    }

    /**
     * <p>
     * The JSON string that specifies the location where the metadata model will be created. Selection rules must
     * specify a single schema. For more information, see Selection Rules in the DMS User Guide.
     * </p>
     * 
     * @return The JSON string that specifies the location where the metadata model will be created. Selection rules
     *         must specify a single schema. For more information, see Selection Rules in the DMS User Guide.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    /**
     * <p>
     * The name of the metadata model.
     * </p>
     * 
     * @return The name of the metadata model.
     */
    public final String metadataModelName() {
        return metadataModelName;
    }

    /**
     * <p>
     * The properties of metadata model in JSON format. This object is a Union. Only one member of this object can be
     * specified or returned.
     * </p>
     * 
     * @return The properties of metadata model in JSON format. This object is a Union. Only one member of this object
     *         can be specified or returned.
     */
    public final MetadataModelProperties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(metadataModelName());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataModelCreationRequest)) {
            return false;
        }
        StartMetadataModelCreationRequest other = (StartMetadataModelCreationRequest) obj;
        return Objects.equals(migrationProjectIdentifier(), other.migrationProjectIdentifier())
                && Objects.equals(selectionRules(), other.selectionRules())
                && Objects.equals(metadataModelName(), other.metadataModelName())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMetadataModelCreationRequest")
                .add("MigrationProjectIdentifier", migrationProjectIdentifier()).add("SelectionRules", selectionRules())
                .add("MetadataModelName", metadataModelName()).add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MigrationProjectIdentifier":
            return Optional.ofNullable(clazz.cast(migrationProjectIdentifier()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        case "MetadataModelName":
            return Optional.ofNullable(clazz.cast(metadataModelName()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        map.put("MetadataModelName", METADATA_MODEL_NAME_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataModelCreationRequest, T> g) {
        return obj -> g.apply((StartMetadataModelCreationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMetadataModelCreationRequest> {
        /**
         * <p>
         * The migration project name or Amazon Resource Name (ARN).
         * </p>
         * 
         * @param migrationProjectIdentifier
         *        The migration project name or Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectIdentifier(String migrationProjectIdentifier);

        /**
         * <p>
         * The JSON string that specifies the location where the metadata model will be created. Selection rules must
         * specify a single schema. For more information, see Selection Rules in the DMS User Guide.
         * </p>
         * 
         * @param selectionRules
         *        The JSON string that specifies the location where the metadata model will be created. Selection rules
         *        must specify a single schema. For more information, see Selection Rules in the DMS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);

        /**
         * <p>
         * The name of the metadata model.
         * </p>
         * 
         * @param metadataModelName
         *        The name of the metadata model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataModelName(String metadataModelName);

        /**
         * <p>
         * The properties of metadata model in JSON format. This object is a Union. Only one member of this object can
         * be specified or returned.
         * </p>
         * 
         * @param properties
         *        The properties of metadata model in JSON format. This object is a Union. Only one member of this
         *        object can be specified or returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(MetadataModelProperties properties);

        /**
         * <p>
         * The properties of metadata model in JSON format. This object is a Union. Only one member of this object can
         * be specified or returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetadataModelProperties.Builder} avoiding
         * the need to create one manually via {@link MetadataModelProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataModelProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #properties(MetadataModelProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link MetadataModelProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(MetadataModelProperties)
         */
        default Builder properties(Consumer<MetadataModelProperties.Builder> properties) {
            return properties(MetadataModelProperties.builder().applyMutation(properties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String migrationProjectIdentifier;

        private String selectionRules;

        private String metadataModelName;

        private MetadataModelProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataModelCreationRequest model) {
            super(model);
            migrationProjectIdentifier(model.migrationProjectIdentifier);
            selectionRules(model.selectionRules);
            metadataModelName(model.metadataModelName);
            properties(model.properties);
        }

        public final String getMigrationProjectIdentifier() {
            return migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getMetadataModelName() {
            return metadataModelName;
        }

        public final void setMetadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
        }

        @Override
        public final Builder metadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
            return this;
        }

        public final MetadataModelProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(MetadataModelProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(MetadataModelProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataModelCreationRequest build() {
            return new StartMetadataModelCreationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
