/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a schema conversion application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SCApplicationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<SCApplicationAttributes.Builder, SCApplicationAttributes> {
    private static final SdkField<String> S3_BUCKET_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketPath").getter(getter(SCApplicationAttributes::s3BucketPath))
            .setter(setter(Builder::s3BucketPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPath").build()).build();

    private static final SdkField<String> S3_BUCKET_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketRoleArn").getter(getter(SCApplicationAttributes::s3BucketRoleArn))
            .setter(setter(Builder::s3BucketRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_PATH_FIELD,
            S3_BUCKET_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3BucketPath;

    private final String s3BucketRoleArn;

    private SCApplicationAttributes(BuilderImpl builder) {
        this.s3BucketPath = builder.s3BucketPath;
        this.s3BucketRoleArn = builder.s3BucketRoleArn;
    }

    /**
     * <p>
     * The path for the Amazon S3 bucket that the application uses for exporting assessment reports.
     * </p>
     * 
     * @return The path for the Amazon S3 bucket that the application uses for exporting assessment reports.
     */
    public final String s3BucketPath() {
        return s3BucketPath;
    }

    /**
     * <p>
     * The ARN for the role the application uses to access its Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN for the role the application uses to access its Amazon S3 bucket.
     */
    public final String s3BucketRoleArn() {
        return s3BucketRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SCApplicationAttributes)) {
            return false;
        }
        SCApplicationAttributes other = (SCApplicationAttributes) obj;
        return Objects.equals(s3BucketPath(), other.s3BucketPath()) && Objects.equals(s3BucketRoleArn(), other.s3BucketRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SCApplicationAttributes").add("S3BucketPath", s3BucketPath())
                .add("S3BucketRoleArn", s3BucketRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketPath":
            return Optional.ofNullable(clazz.cast(s3BucketPath()));
        case "S3BucketRoleArn":
            return Optional.ofNullable(clazz.cast(s3BucketRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3BucketPath", S3_BUCKET_PATH_FIELD);
        map.put("S3BucketRoleArn", S3_BUCKET_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SCApplicationAttributes, T> g) {
        return obj -> g.apply((SCApplicationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SCApplicationAttributes> {
        /**
         * <p>
         * The path for the Amazon S3 bucket that the application uses for exporting assessment reports.
         * </p>
         * 
         * @param s3BucketPath
         *        The path for the Amazon S3 bucket that the application uses for exporting assessment reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketPath(String s3BucketPath);

        /**
         * <p>
         * The ARN for the role the application uses to access its Amazon S3 bucket.
         * </p>
         * 
         * @param s3BucketRoleArn
         *        The ARN for the role the application uses to access its Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketRoleArn(String s3BucketRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketPath;

        private String s3BucketRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SCApplicationAttributes model) {
            s3BucketPath(model.s3BucketPath);
            s3BucketRoleArn(model.s3BucketRoleArn);
        }

        public final String getS3BucketPath() {
            return s3BucketPath;
        }

        public final void setS3BucketPath(String s3BucketPath) {
            this.s3BucketPath = s3BucketPath;
        }

        @Override
        public final Builder s3BucketPath(String s3BucketPath) {
            this.s3BucketPath = s3BucketPath;
            return this;
        }

        public final String getS3BucketRoleArn() {
            return s3BucketRoleArn;
        }

        public final void setS3BucketRoleArn(String s3BucketRoleArn) {
            this.s3BucketRoleArn = s3BucketRoleArn;
        }

        @Override
        public final Builder s3BucketRoleArn(String s3BucketRoleArn) {
            this.s3BucketRoleArn = s3BucketRoleArn;
            return this;
        }

        @Override
        public SCApplicationAttributes build() {
            return new SCApplicationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
