/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the progress of the schema conversion operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Progress implements SdkPojo, Serializable, ToCopyableBuilder<Progress.Builder, Progress> {
    private static final SdkField<Double> PROGRESS_PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ProgressPercent").getter(getter(Progress::progressPercent)).setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()).build();

    private static final SdkField<Long> TOTAL_OBJECTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalObjects").getter(getter(Progress::totalObjects)).setter(setter(Builder::totalObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalObjects").build()).build();

    private static final SdkField<String> PROGRESS_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgressStep").getter(getter(Progress::progressStep)).setter(setter(Builder::progressStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressStep").build()).build();

    private static final SdkField<ProcessedObject> PROCESSED_OBJECT_FIELD = SdkField
            .<ProcessedObject> builder(MarshallingType.SDK_POJO).memberName("ProcessedObject")
            .getter(getter(Progress::processedObject)).setter(setter(Builder::processedObject))
            .constructor(ProcessedObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_PERCENT_FIELD,
            TOTAL_OBJECTS_FIELD, PROGRESS_STEP_FIELD, PROCESSED_OBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double progressPercent;

    private final Long totalObjects;

    private final String progressStep;

    private final ProcessedObject processedObject;

    private Progress(BuilderImpl builder) {
        this.progressPercent = builder.progressPercent;
        this.totalObjects = builder.totalObjects;
        this.progressStep = builder.progressStep;
        this.processedObject = builder.processedObject;
    }

    /**
     * <p>
     * The percent complete for the current step of the schema conversion operation.
     * </p>
     * 
     * @return The percent complete for the current step of the schema conversion operation.
     */
    public final Double progressPercent() {
        return progressPercent;
    }

    /**
     * <p>
     * The number of objects in this schema conversion operation.
     * </p>
     * 
     * @return The number of objects in this schema conversion operation.
     */
    public final Long totalObjects() {
        return totalObjects;
    }

    /**
     * <p>
     * The step of the schema conversion operation. This parameter can store one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> – The operation is running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LOADING_METADATA</code> – Loads metadata from the source database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNTING_OBJECTS</code> – Determines the number of objects involved in the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANALYZING</code> – Analyzes the source database objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONVERTING</code> – Converts the source database objects to a format compatible with the target database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLYING</code> – Applies the converted code to the target database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FINISHED</code> – The operation completed successfully.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The step of the schema conversion operation. This parameter can store one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> – The operation is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LOADING_METADATA</code> – Loads metadata from the source database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNTING_OBJECTS</code> – Determines the number of objects involved in the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANALYZING</code> – Analyzes the source database objects.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONVERTING</code> – Converts the source database objects to a format compatible with the target
     *         database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLYING</code> – Applies the converted code to the target database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FINISHED</code> – The operation completed successfully.
     *         </p>
     *         </li>
     */
    public final String progressStep() {
        return progressStep;
    }

    /**
     * <p>
     * The name of the database object that the schema conversion operation currently uses.
     * </p>
     * 
     * @return The name of the database object that the schema conversion operation currently uses.
     */
    public final ProcessedObject processedObject() {
        return processedObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(totalObjects());
        hashCode = 31 * hashCode + Objects.hashCode(progressStep());
        hashCode = 31 * hashCode + Objects.hashCode(processedObject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Progress)) {
            return false;
        }
        Progress other = (Progress) obj;
        return Objects.equals(progressPercent(), other.progressPercent()) && Objects.equals(totalObjects(), other.totalObjects())
                && Objects.equals(progressStep(), other.progressStep())
                && Objects.equals(processedObject(), other.processedObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Progress").add("ProgressPercent", progressPercent()).add("TotalObjects", totalObjects())
                .add("ProgressStep", progressStep()).add("ProcessedObject", processedObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        case "TotalObjects":
            return Optional.ofNullable(clazz.cast(totalObjects()));
        case "ProgressStep":
            return Optional.ofNullable(clazz.cast(progressStep()));
        case "ProcessedObject":
            return Optional.ofNullable(clazz.cast(processedObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressPercent", PROGRESS_PERCENT_FIELD);
        map.put("TotalObjects", TOTAL_OBJECTS_FIELD);
        map.put("ProgressStep", PROGRESS_STEP_FIELD);
        map.put("ProcessedObject", PROCESSED_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Progress, T> g) {
        return obj -> g.apply((Progress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Progress> {
        /**
         * <p>
         * The percent complete for the current step of the schema conversion operation.
         * </p>
         * 
         * @param progressPercent
         *        The percent complete for the current step of the schema conversion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Double progressPercent);

        /**
         * <p>
         * The number of objects in this schema conversion operation.
         * </p>
         * 
         * @param totalObjects
         *        The number of objects in this schema conversion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalObjects(Long totalObjects);

        /**
         * <p>
         * The step of the schema conversion operation. This parameter can store one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> – The operation is running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LOADING_METADATA</code> – Loads metadata from the source database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNTING_OBJECTS</code> – Determines the number of objects involved in the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANALYZING</code> – Analyzes the source database objects.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONVERTING</code> – Converts the source database objects to a format compatible with the target
         * database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLYING</code> – Applies the converted code to the target database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FINISHED</code> – The operation completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param progressStep
         *        The step of the schema conversion operation. This parameter can store one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> – The operation is running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LOADING_METADATA</code> – Loads metadata from the source database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNTING_OBJECTS</code> – Determines the number of objects involved in the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANALYZING</code> – Analyzes the source database objects.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONVERTING</code> – Converts the source database objects to a format compatible with the target
         *        database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLYING</code> – Applies the converted code to the target database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FINISHED</code> – The operation completed successfully.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressStep(String progressStep);

        /**
         * <p>
         * The name of the database object that the schema conversion operation currently uses.
         * </p>
         * 
         * @param processedObject
         *        The name of the database object that the schema conversion operation currently uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedObject(ProcessedObject processedObject);

        /**
         * <p>
         * The name of the database object that the schema conversion operation currently uses.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessedObject.Builder} avoiding the
         * need to create one manually via {@link ProcessedObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessedObject.Builder#build()} is called immediately and its
         * result is passed to {@link #processedObject(ProcessedObject)}.
         * 
         * @param processedObject
         *        a consumer that will call methods on {@link ProcessedObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processedObject(ProcessedObject)
         */
        default Builder processedObject(Consumer<ProcessedObject.Builder> processedObject) {
            return processedObject(ProcessedObject.builder().applyMutation(processedObject).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double progressPercent;

        private Long totalObjects;

        private String progressStep;

        private ProcessedObject processedObject;

        private BuilderImpl() {
        }

        private BuilderImpl(Progress model) {
            progressPercent(model.progressPercent);
            totalObjects(model.totalObjects);
            progressStep(model.progressStep);
            processedObject(model.processedObject);
        }

        public final Double getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final Long getTotalObjects() {
            return totalObjects;
        }

        public final void setTotalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
        }

        @Override
        public final Builder totalObjects(Long totalObjects) {
            this.totalObjects = totalObjects;
            return this;
        }

        public final String getProgressStep() {
            return progressStep;
        }

        public final void setProgressStep(String progressStep) {
            this.progressStep = progressStep;
        }

        @Override
        public final Builder progressStep(String progressStep) {
            this.progressStep = progressStep;
            return this;
        }

        public final ProcessedObject.Builder getProcessedObject() {
            return processedObject != null ? processedObject.toBuilder() : null;
        }

        public final void setProcessedObject(ProcessedObject.BuilderImpl processedObject) {
            this.processedObject = processedObject != null ? processedObject.build() : null;
        }

        @Override
        public final Builder processedObject(ProcessedObject processedObject) {
            this.processedObject = processedObject;
            return this;
        }

        @Override
        public Progress build() {
            return new Progress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
