/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a metadata model, including its name and selection rules for location identification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataModelReference implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataModelReference.Builder, MetadataModelReference> {
    private static final SdkField<String> METADATA_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataModelName").getter(getter(MetadataModelReference::metadataModelName))
            .setter(setter(Builder::metadataModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelName").build()).build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(MetadataModelReference::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_MODEL_NAME_FIELD,
            SELECTION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metadataModelName;

    private final String selectionRules;

    private MetadataModelReference(BuilderImpl builder) {
        this.metadataModelName = builder.metadataModelName;
        this.selectionRules = builder.selectionRules;
    }

    /**
     * <p>
     * The name of the metadata model.
     * </p>
     * 
     * @return The name of the metadata model.
     */
    public final String metadataModelName() {
        return metadataModelName;
    }

    /**
     * <p>
     * The JSON string representing metadata model location.
     * </p>
     * 
     * @return The JSON string representing metadata model location.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataModelName());
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataModelReference)) {
            return false;
        }
        MetadataModelReference other = (MetadataModelReference) obj;
        return Objects.equals(metadataModelName(), other.metadataModelName())
                && Objects.equals(selectionRules(), other.selectionRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataModelReference").add("MetadataModelName", metadataModelName())
                .add("SelectionRules", selectionRules()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataModelName":
            return Optional.ofNullable(clazz.cast(metadataModelName()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetadataModelName", METADATA_MODEL_NAME_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataModelReference, T> g) {
        return obj -> g.apply((MetadataModelReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataModelReference> {
        /**
         * <p>
         * The name of the metadata model.
         * </p>
         * 
         * @param metadataModelName
         *        The name of the metadata model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataModelName(String metadataModelName);

        /**
         * <p>
         * The JSON string representing metadata model location.
         * </p>
         * 
         * @param selectionRules
         *        The JSON string representing metadata model location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);
    }

    static final class BuilderImpl implements Builder {
        private String metadataModelName;

        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataModelReference model) {
            metadataModelName(model.metadataModelName);
            selectionRules(model.selectionRules);
        }

        public final String getMetadataModelName() {
            return metadataModelName;
        }

        public final void setMetadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
        }

        @Override
        public final Builder metadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        @Override
        public MetadataModelReference build() {
            return new MetadataModelReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
