/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetadataModelChildrenResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeMetadataModelChildrenResponse.Builder, DescribeMetadataModelChildrenResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeMetadataModelChildrenResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<MetadataModelReference>> METADATA_MODEL_CHILDREN_FIELD = SdkField
            .<List<MetadataModelReference>> builder(MarshallingType.LIST)
            .memberName("MetadataModelChildren")
            .getter(getter(DescribeMetadataModelChildrenResponse::metadataModelChildren))
            .setter(setter(Builder::metadataModelChildren))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelChildren").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataModelReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataModelReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            METADATA_MODEL_CHILDREN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<MetadataModelReference> metadataModelChildren;

    private DescribeMetadataModelChildrenResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.metadataModelChildren = builder.metadataModelChildren;
    }

    /**
     * <p>
     * Specifies the unique pagination token that makes it possible to display the next page of metadata model children.
     * If a marker is returned, there are more metadata model children available.
     * </p>
     * 
     * @return Specifies the unique pagination token that makes it possible to display the next page of metadata model
     *         children. If a marker is returned, there are more metadata model children available.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataModelChildren property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetadataModelChildren() {
        return metadataModelChildren != null && !(metadataModelChildren instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of child metadata models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataModelChildren} method.
     * </p>
     * 
     * @return A list of child metadata models.
     */
    public final List<MetadataModelReference> metadataModelChildren() {
        return metadataModelChildren;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataModelChildren() ? metadataModelChildren() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetadataModelChildrenResponse)) {
            return false;
        }
        DescribeMetadataModelChildrenResponse other = (DescribeMetadataModelChildrenResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasMetadataModelChildren() == other.hasMetadataModelChildren()
                && Objects.equals(metadataModelChildren(), other.metadataModelChildren());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetadataModelChildrenResponse").add("Marker", marker())
                .add("MetadataModelChildren", hasMetadataModelChildren() ? metadataModelChildren() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MetadataModelChildren":
            return Optional.ofNullable(clazz.cast(metadataModelChildren()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("MetadataModelChildren", METADATA_MODEL_CHILDREN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetadataModelChildrenResponse, T> g) {
        return obj -> g.apply((DescribeMetadataModelChildrenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetadataModelChildrenResponse> {
        /**
         * <p>
         * Specifies the unique pagination token that makes it possible to display the next page of metadata model
         * children. If a marker is returned, there are more metadata model children available.
         * </p>
         * 
         * @param marker
         *        Specifies the unique pagination token that makes it possible to display the next page of metadata
         *        model children. If a marker is returned, there are more metadata model children available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of child metadata models.
         * </p>
         * 
         * @param metadataModelChildren
         *        A list of child metadata models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataModelChildren(Collection<MetadataModelReference> metadataModelChildren);

        /**
         * <p>
         * A list of child metadata models.
         * </p>
         * 
         * @param metadataModelChildren
         *        A list of child metadata models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataModelChildren(MetadataModelReference... metadataModelChildren);

        /**
         * <p>
         * A list of child metadata models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference.Builder#build()} is
         * called immediately and its result is passed to {@link #metadataModelChildren(List<MetadataModelReference>)}.
         * 
         * @param metadataModelChildren
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataModelChildren(java.util.Collection<MetadataModelReference>)
         */
        Builder metadataModelChildren(Consumer<MetadataModelReference.Builder>... metadataModelChildren);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<MetadataModelReference> metadataModelChildren = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetadataModelChildrenResponse model) {
            super(model);
            marker(model.marker);
            metadataModelChildren(model.metadataModelChildren);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<MetadataModelReference.Builder> getMetadataModelChildren() {
            List<MetadataModelReference.Builder> result = MetadataModelReferenceListCopier
                    .copyToBuilder(this.metadataModelChildren);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataModelChildren(Collection<MetadataModelReference.BuilderImpl> metadataModelChildren) {
            this.metadataModelChildren = MetadataModelReferenceListCopier.copyFromBuilder(metadataModelChildren);
        }

        @Override
        public final Builder metadataModelChildren(Collection<MetadataModelReference> metadataModelChildren) {
            this.metadataModelChildren = MetadataModelReferenceListCopier.copy(metadataModelChildren);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataModelChildren(MetadataModelReference... metadataModelChildren) {
            metadataModelChildren(Arrays.asList(metadataModelChildren));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataModelChildren(Consumer<MetadataModelReference.Builder>... metadataModelChildren) {
            metadataModelChildren(Stream.of(metadataModelChildren)
                    .map(c -> MetadataModelReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMetadataModelChildrenResponse build() {
            return new DescribeMetadataModelChildrenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
