/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.FleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.FleetAdvisorLsaAnalysisResponseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetAdvisorLsaAnalysisResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeFleetAdvisorLsaAnalysisResponse> {
    private static final SdkField<List<FleetAdvisorLsaAnalysisResponse>> ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Analysis").getter(DescribeFleetAdvisorLsaAnalysisResponse.getter(DescribeFleetAdvisorLsaAnalysisResponse::analysis)).setter(DescribeFleetAdvisorLsaAnalysisResponse.setter(Builder::analysis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAdvisorLsaAnalysisResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetAdvisorLsaAnalysisResponse.getter(DescribeFleetAdvisorLsaAnalysisResponse::nextToken)).setter(DescribeFleetAdvisorLsaAnalysisResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetAdvisorLsaAnalysisResponse.memberNameToFieldInitializer();
    private final List<FleetAdvisorLsaAnalysisResponse> analysis;
    private final String nextToken;

    private DescribeFleetAdvisorLsaAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.analysis = builder.analysis;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnalysis() {
        return this.analysis != null && !(this.analysis instanceof SdkAutoConstructList);
    }

    public final List<FleetAdvisorLsaAnalysisResponse> analysis() {
        return this.analysis;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysis() ? this.analysis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorLsaAnalysisResponse)) {
            return false;
        }
        DescribeFleetAdvisorLsaAnalysisResponse other = (DescribeFleetAdvisorLsaAnalysisResponse)((Object)obj);
        return this.hasAnalysis() == other.hasAnalysis() && Objects.equals(this.analysis(), other.analysis()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetAdvisorLsaAnalysisResponse").add("Analysis", this.hasAnalysis() ? this.analysis() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Analysis": {
                return Optional.ofNullable(clazz.cast(this.analysis()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Analysis", ANALYSIS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorLsaAnalysisResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorLsaAnalysisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<FleetAdvisorLsaAnalysisResponse> analysis = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorLsaAnalysisResponse model) {
            super(model);
            this.analysis(model.analysis);
            this.nextToken(model.nextToken);
        }

        public final List<FleetAdvisorLsaAnalysisResponse.Builder> getAnalysis() {
            List<FleetAdvisorLsaAnalysisResponse.Builder> result = FleetAdvisorLsaAnalysisResponseListCopier.copyToBuilder(this.analysis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysis(Collection<FleetAdvisorLsaAnalysisResponse.BuilderImpl> analysis) {
            this.analysis = FleetAdvisorLsaAnalysisResponseListCopier.copyFromBuilder(analysis);
        }

        @Override
        public final Builder analysis(Collection<FleetAdvisorLsaAnalysisResponse> analysis) {
            this.analysis = FleetAdvisorLsaAnalysisResponseListCopier.copy(analysis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysis(FleetAdvisorLsaAnalysisResponse ... analysis) {
            this.analysis(Arrays.asList(analysis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysis(Consumer<FleetAdvisorLsaAnalysisResponse.Builder> ... analysis) {
            this.analysis(Stream.of(analysis).map(c -> (FleetAdvisorLsaAnalysisResponse)((FleetAdvisorLsaAnalysisResponse.Builder)FleetAdvisorLsaAnalysisResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorLsaAnalysisResponse build() {
            return new DescribeFleetAdvisorLsaAnalysisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetAdvisorLsaAnalysisResponse> {
        public Builder analysis(Collection<FleetAdvisorLsaAnalysisResponse> var1);

        public Builder analysis(FleetAdvisorLsaAnalysisResponse ... var1);

        public Builder analysis(Consumer<FleetAdvisorLsaAnalysisResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

