/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType;
import software.amazon.awssdk.services.databasemigration.model.SupportedEndpointTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointTypesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEndpointTypesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeEndpointTypesResponse.getter(DescribeEndpointTypesResponse::marker)).setter(DescribeEndpointTypesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<SupportedEndpointType>> SUPPORTED_ENDPOINT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEndpointTypes").getter(DescribeEndpointTypesResponse.getter(DescribeEndpointTypesResponse::supportedEndpointTypes)).setter(DescribeEndpointTypesResponse.setter(Builder::supportedEndpointTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEndpointTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedEndpointType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, SUPPORTED_ENDPOINT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEndpointTypesResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<SupportedEndpointType> supportedEndpointTypes;

    private DescribeEndpointTypesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.supportedEndpointTypes = builder.supportedEndpointTypes;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasSupportedEndpointTypes() {
        return this.supportedEndpointTypes != null && !(this.supportedEndpointTypes instanceof SdkAutoConstructList);
    }

    public final List<SupportedEndpointType> supportedEndpointTypes() {
        return this.supportedEndpointTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEndpointTypes() ? this.supportedEndpointTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointTypesResponse)) {
            return false;
        }
        DescribeEndpointTypesResponse other = (DescribeEndpointTypesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasSupportedEndpointTypes() == other.hasSupportedEndpointTypes() && Objects.equals(this.supportedEndpointTypes(), other.supportedEndpointTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointTypesResponse").add("Marker", (Object)this.marker()).add("SupportedEndpointTypes", this.hasSupportedEndpointTypes() ? this.supportedEndpointTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "SupportedEndpointTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedEndpointTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("SupportedEndpointTypes", SUPPORTED_ENDPOINT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointTypesResponse, T> g) {
        return obj -> g.apply((DescribeEndpointTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SupportedEndpointType> supportedEndpointTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointTypesResponse model) {
            super(model);
            this.marker(model.marker);
            this.supportedEndpointTypes(model.supportedEndpointTypes);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<SupportedEndpointType.Builder> getSupportedEndpointTypes() {
            List<SupportedEndpointType.Builder> result = SupportedEndpointTypeListCopier.copyToBuilder(this.supportedEndpointTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedEndpointTypes(Collection<SupportedEndpointType.BuilderImpl> supportedEndpointTypes) {
            this.supportedEndpointTypes = SupportedEndpointTypeListCopier.copyFromBuilder(supportedEndpointTypes);
        }

        @Override
        public final Builder supportedEndpointTypes(Collection<SupportedEndpointType> supportedEndpointTypes) {
            this.supportedEndpointTypes = SupportedEndpointTypeListCopier.copy(supportedEndpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEndpointTypes(SupportedEndpointType ... supportedEndpointTypes) {
            this.supportedEndpointTypes(Arrays.asList(supportedEndpointTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEndpointTypes(Consumer<SupportedEndpointType.Builder> ... supportedEndpointTypes) {
            this.supportedEndpointTypes(Stream.of(supportedEndpointTypes).map(c -> (SupportedEndpointType)((SupportedEndpointType.Builder)SupportedEndpointType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEndpointTypesResponse build() {
            return new DescribeEndpointTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointTypesResponse> {
        public Builder marker(String var1);

        public Builder supportedEndpointTypes(Collection<SupportedEndpointType> var1);

        public Builder supportedEndpointTypes(SupportedEndpointType ... var1);

        public Builder supportedEndpointTypes(Consumer<SupportedEndpointType.Builder> ... var1);
    }
}

