/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue;
import software.amazon.awssdk.services.databasemigration.model.TableListToReloadCopier;
import software.amazon.awssdk.services.databasemigration.model.TableToReload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReloadReplicationTablesRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ReloadReplicationTablesRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigArn").getter(ReloadReplicationTablesRequest.getter(ReloadReplicationTablesRequest::replicationConfigArn)).setter(ReloadReplicationTablesRequest.setter(Builder::replicationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build()}).build();
    private static final SdkField<List<TableToReload>> TABLES_TO_RELOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TablesToReload").getter(ReloadReplicationTablesRequest.getter(ReloadReplicationTablesRequest::tablesToReload)).setter(ReloadReplicationTablesRequest.setter(Builder::tablesToReload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesToReload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableToReload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RELOAD_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReloadOption").getter(ReloadReplicationTablesRequest.getter(ReloadReplicationTablesRequest::reloadOptionAsString)).setter(ReloadReplicationTablesRequest.setter(Builder::reloadOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReloadOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD, TABLES_TO_RELOAD_FIELD, RELOAD_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReloadReplicationTablesRequest.memberNameToFieldInitializer();
    private final String replicationConfigArn;
    private final List<TableToReload> tablesToReload;
    private final String reloadOption;

    private ReloadReplicationTablesRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.tablesToReload = builder.tablesToReload;
        this.reloadOption = builder.reloadOption;
    }

    public final String replicationConfigArn() {
        return this.replicationConfigArn;
    }

    public final boolean hasTablesToReload() {
        return this.tablesToReload != null && !(this.tablesToReload instanceof SdkAutoConstructList);
    }

    public final List<TableToReload> tablesToReload() {
        return this.tablesToReload;
    }

    public final ReloadOptionValue reloadOption() {
        return ReloadOptionValue.fromValue(this.reloadOption);
    }

    public final String reloadOptionAsString() {
        return this.reloadOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTablesToReload() ? this.tablesToReload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reloadOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadReplicationTablesRequest)) {
            return false;
        }
        ReloadReplicationTablesRequest other = (ReloadReplicationTablesRequest)((Object)obj);
        return Objects.equals(this.replicationConfigArn(), other.replicationConfigArn()) && this.hasTablesToReload() == other.hasTablesToReload() && Objects.equals(this.tablesToReload(), other.tablesToReload()) && Objects.equals(this.reloadOptionAsString(), other.reloadOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReloadReplicationTablesRequest").add("ReplicationConfigArn", (Object)this.replicationConfigArn()).add("TablesToReload", this.hasTablesToReload() ? this.tablesToReload() : null).add("ReloadOption", (Object)this.reloadOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigArn()));
            }
            case "TablesToReload": {
                return Optional.ofNullable(clazz.cast(this.tablesToReload()));
            }
            case "ReloadOption": {
                return Optional.ofNullable(clazz.cast(this.reloadOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
        map.put("TablesToReload", TABLES_TO_RELOAD_FIELD);
        map.put("ReloadOption", RELOAD_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReloadReplicationTablesRequest, T> g) {
        return obj -> g.apply((ReloadReplicationTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationConfigArn;
        private List<TableToReload> tablesToReload = DefaultSdkAutoConstructList.getInstance();
        private String reloadOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ReloadReplicationTablesRequest model) {
            super(model);
            this.replicationConfigArn(model.replicationConfigArn);
            this.tablesToReload(model.tablesToReload);
            this.reloadOption(model.reloadOption);
        }

        public final String getReplicationConfigArn() {
            return this.replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final List<TableToReload.Builder> getTablesToReload() {
            List<TableToReload.Builder> result = TableListToReloadCopier.copyToBuilder(this.tablesToReload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTablesToReload(Collection<TableToReload.BuilderImpl> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copyFromBuilder(tablesToReload);
        }

        @Override
        public final Builder tablesToReload(Collection<TableToReload> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copy(tablesToReload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(TableToReload ... tablesToReload) {
            this.tablesToReload(Arrays.asList(tablesToReload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(Consumer<TableToReload.Builder> ... tablesToReload) {
            this.tablesToReload(Stream.of(tablesToReload).map(c -> (TableToReload)((TableToReload.Builder)TableToReload.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReloadOption() {
            return this.reloadOption;
        }

        public final void setReloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
        }

        @Override
        public final Builder reloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
            return this;
        }

        @Override
        public final Builder reloadOption(ReloadOptionValue reloadOption) {
            this.reloadOption(reloadOption == null ? null : reloadOption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReloadReplicationTablesRequest build() {
            return new ReloadReplicationTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReloadReplicationTablesRequest> {
        public Builder replicationConfigArn(String var1);

        public Builder tablesToReload(Collection<TableToReload> var1);

        public Builder tablesToReload(TableToReload ... var1);

        public Builder tablesToReload(Consumer<TableToReload.Builder> ... var1);

        public Builder reloadOption(String var1);

        public Builder reloadOption(ReloadOptionValue var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

