/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;

public class DescribeTableStatisticsPublisher
implements SdkPublisher<DescribeTableStatisticsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeTableStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTableStatisticsPublisher(DatabaseMigrationAsyncClient client, DescribeTableStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTableStatisticsPublisher(DatabaseMigrationAsyncClient client, DescribeTableStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTableStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTableStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeTableStatisticsResponseFetcher
    implements AsyncPageFetcher<DescribeTableStatisticsResponse> {
        private DescribeTableStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTableStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeTableStatisticsResponse> nextPage(DescribeTableStatisticsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTableStatisticsPublisher.this.client.describeTableStatistics(DescribeTableStatisticsPublisher.this.firstRequest);
            }
            return DescribeTableStatisticsPublisher.this.client.describeTableStatistics((DescribeTableStatisticsRequest)((Object)DescribeTableStatisticsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

