/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MoveReplicationTaskRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, MoveReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(MoveReplicationTaskRequest.getter(MoveReplicationTaskRequest::replicationTaskArn)).setter(MoveReplicationTaskRequest.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<String> TARGET_REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetReplicationInstanceArn").getter(MoveReplicationTaskRequest.getter(MoveReplicationTaskRequest::targetReplicationInstanceArn)).setter(MoveReplicationTaskRequest.setter(Builder::targetReplicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReplicationInstanceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, TARGET_REPLICATION_INSTANCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplicationTaskArn", REPLICATION_TASK_ARN_FIELD);
            this.put("TargetReplicationInstanceArn", TARGET_REPLICATION_INSTANCE_ARN_FIELD);
        }
    });
    private final String replicationTaskArn;
    private final String targetReplicationInstanceArn;

    private MoveReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.targetReplicationInstanceArn = builder.targetReplicationInstanceArn;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final String targetReplicationInstanceArn() {
        return this.targetReplicationInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReplicationInstanceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveReplicationTaskRequest)) {
            return false;
        }
        MoveReplicationTaskRequest other = (MoveReplicationTaskRequest)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.targetReplicationInstanceArn(), other.targetReplicationInstanceArn());
    }

    public final String toString() {
        return ToString.builder((String)"MoveReplicationTaskRequest").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("TargetReplicationInstanceArn", (Object)this.targetReplicationInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "TargetReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.targetReplicationInstanceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MoveReplicationTaskRequest, T> g) {
        return obj -> g.apply((MoveReplicationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private String targetReplicationInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveReplicationTaskRequest model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.targetReplicationInstanceArn(model.targetReplicationInstanceArn);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final String getTargetReplicationInstanceArn() {
            return this.targetReplicationInstanceArn;
        }

        public final void setTargetReplicationInstanceArn(String targetReplicationInstanceArn) {
            this.targetReplicationInstanceArn = targetReplicationInstanceArn;
        }

        @Override
        public final Builder targetReplicationInstanceArn(String targetReplicationInstanceArn) {
            this.targetReplicationInstanceArn = targetReplicationInstanceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveReplicationTaskRequest build() {
            return new MoveReplicationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MoveReplicationTaskRequest> {
        public Builder replicationTaskArn(String var1);

        public Builder targetReplicationInstanceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

