/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;

public class DescribeSchemasIterable
implements SdkIterable<DescribeSchemasResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeSchemasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSchemasIterable(DatabaseMigrationClient client, DescribeSchemasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSchemasResponseFetcher();
    }

    public Iterator<DescribeSchemasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeSchemasResponseFetcher
    implements SyncPageFetcher<DescribeSchemasResponse> {
        private DescribeSchemasResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeSchemasResponse nextPage(DescribeSchemasResponse previousPage) {
            if (previousPage == null) {
                return DescribeSchemasIterable.this.client.describeSchemas(DescribeSchemasIterable.this.firstRequest);
            }
            return DescribeSchemasIterable.this.client.describeSchemas((DescribeSchemasRequest)((Object)DescribeSchemasIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

