/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStartRecommendationsRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, BatchStartRecommendationsRequest> {
    private static final SdkField<List<StartRecommendationsRequestEntry>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Data").getter(BatchStartRecommendationsRequest.getter(BatchStartRecommendationsRequest::data)).setter(BatchStartRecommendationsRequest.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartRecommendationsRequestEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Data", DATA_FIELD);
        }
    });
    private final List<StartRecommendationsRequestEntry> data;

    private BatchStartRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.data = builder.data;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructList);
    }

    public final List<StartRecommendationsRequestEntry> data() {
        return this.data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartRecommendationsRequest)) {
            return false;
        }
        BatchStartRecommendationsRequest other = (BatchStartRecommendationsRequest)((Object)obj);
        return this.hasData() == other.hasData() && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStartRecommendationsRequest").add("Data", this.hasData() ? this.data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchStartRecommendationsRequest, T> g) {
        return obj -> g.apply((BatchStartRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private List<StartRecommendationsRequestEntry> data = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartRecommendationsRequest model) {
            super(model);
            this.data(model.data);
        }

        public final List<StartRecommendationsRequestEntry.Builder> getData() {
            List<StartRecommendationsRequestEntry.Builder> result = StartRecommendationsRequestEntryListCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<StartRecommendationsRequestEntry.BuilderImpl> data) {
            this.data = StartRecommendationsRequestEntryListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<StartRecommendationsRequestEntry> data) {
            this.data = StartRecommendationsRequestEntryListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(StartRecommendationsRequestEntry ... data) {
            this.data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<StartRecommendationsRequestEntry.Builder> ... data) {
            this.data(Stream.of(data).map(c -> (StartRecommendationsRequestEntry)((StartRecommendationsRequestEntry.Builder)StartRecommendationsRequestEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStartRecommendationsRequest build() {
            return new BatchStartRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStartRecommendationsRequest> {
        public Builder data(Collection<StartRecommendationsRequestEntry> var1);

        public Builder data(StartRecommendationsRequestEntry ... var1);

        public Builder data(Consumer<StartRecommendationsRequestEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

