/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataMigrationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataMigrationSettings> {
    private static final SdkField<Integer> NUMBER_OF_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfJobs").getter(DataMigrationSettings.getter(DataMigrationSettings::numberOfJobs)).setter(DataMigrationSettings.setter(Builder::numberOfJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfJobs").build()}).build();
    private static final SdkField<Boolean> CLOUDWATCH_LOGS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudwatchLogsEnabled").getter(DataMigrationSettings.getter(DataMigrationSettings::cloudwatchLogsEnabled)).setter(DataMigrationSettings.setter(Builder::cloudwatchLogsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsEnabled").build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(DataMigrationSettings.getter(DataMigrationSettings::selectionRules)).setter(DataMigrationSettings.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_JOBS_FIELD, CLOUDWATCH_LOGS_ENABLED_FIELD, SELECTION_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer numberOfJobs;
    private final Boolean cloudwatchLogsEnabled;
    private final String selectionRules;

    private DataMigrationSettings(BuilderImpl builder) {
        this.numberOfJobs = builder.numberOfJobs;
        this.cloudwatchLogsEnabled = builder.cloudwatchLogsEnabled;
        this.selectionRules = builder.selectionRules;
    }

    public final Integer numberOfJobs() {
        return this.numberOfJobs;
    }

    public final Boolean cloudwatchLogsEnabled() {
        return this.cloudwatchLogsEnabled;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataMigrationSettings)) {
            return false;
        }
        DataMigrationSettings other = (DataMigrationSettings)obj;
        return Objects.equals(this.numberOfJobs(), other.numberOfJobs()) && Objects.equals(this.cloudwatchLogsEnabled(), other.cloudwatchLogsEnabled()) && Objects.equals(this.selectionRules(), other.selectionRules());
    }

    public final String toString() {
        return ToString.builder((String)"DataMigrationSettings").add("NumberOfJobs", (Object)this.numberOfJobs()).add("CloudwatchLogsEnabled", (Object)this.cloudwatchLogsEnabled()).add("SelectionRules", (Object)(this.selectionRules() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfJobs": {
                return Optional.ofNullable(clazz.cast(this.numberOfJobs()));
            }
            case "CloudwatchLogsEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogsEnabled()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataMigrationSettings, T> g) {
        return obj -> g.apply((DataMigrationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numberOfJobs;
        private Boolean cloudwatchLogsEnabled;
        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(DataMigrationSettings model) {
            this.numberOfJobs(model.numberOfJobs);
            this.cloudwatchLogsEnabled(model.cloudwatchLogsEnabled);
            this.selectionRules(model.selectionRules);
        }

        public final Integer getNumberOfJobs() {
            return this.numberOfJobs;
        }

        public final void setNumberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
        }

        @Override
        public final Builder numberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
            return this;
        }

        public final Boolean getCloudwatchLogsEnabled() {
            return this.cloudwatchLogsEnabled;
        }

        public final void setCloudwatchLogsEnabled(Boolean cloudwatchLogsEnabled) {
            this.cloudwatchLogsEnabled = cloudwatchLogsEnabled;
        }

        @Override
        public final Builder cloudwatchLogsEnabled(Boolean cloudwatchLogsEnabled) {
            this.cloudwatchLogsEnabled = cloudwatchLogsEnabled;
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public DataMigrationSettings build() {
            return new DataMigrationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataMigrationSettings> {
        public Builder numberOfJobs(Integer var1);

        public Builder cloudwatchLogsEnabled(Boolean var1);

        public Builder selectionRules(String var1);
    }
}

