/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationWaiter;
import software.amazon.awssdk.services.databasemigration.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultDatabaseMigrationWaiter
implements DatabaseMigrationWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final DatabaseMigrationClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeConnectionsResponse> testConnectionSucceedsWaiter;
    private final Waiter<DescribeEndpointsResponse> endpointDeletedWaiter;
    private final Waiter<DescribeReplicationInstancesResponse> replicationInstanceAvailableWaiter;
    private final Waiter<DescribeReplicationInstancesResponse> replicationInstanceDeletedWaiter;
    private final Waiter<DescribeReplicationTasksResponse> replicationTaskReadyWaiter;
    private final Waiter<DescribeReplicationTasksResponse> replicationTaskStoppedWaiter;
    private final Waiter<DescribeReplicationTasksResponse> replicationTaskRunningWaiter;
    private final Waiter<DescribeReplicationTasksResponse> replicationTaskDeletedWaiter;

    private DefaultDatabaseMigrationWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DatabaseMigrationClient)DatabaseMigrationClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.testConnectionSucceedsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeConnectionsResponse.class).acceptors(DefaultDatabaseMigrationWaiter.testConnectionSucceedsWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.testConnectionSucceedsWaiterConfig(builder.overrideConfiguration))).build();
        this.endpointDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeEndpointsResponse.class).acceptors(DefaultDatabaseMigrationWaiter.endpointDeletedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.endpointDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationInstanceAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationInstancesResponse.class).acceptors(DefaultDatabaseMigrationWaiter.replicationInstanceAvailableWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.replicationInstanceAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationInstanceDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationInstancesResponse.class).acceptors(DefaultDatabaseMigrationWaiter.replicationInstanceDeletedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.replicationInstanceDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationTaskReadyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationWaiter.replicationTaskReadyWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.replicationTaskReadyWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationTaskStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationWaiter.replicationTaskStoppedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.replicationTaskStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationTaskRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationWaiter.replicationTaskRunningWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.replicationTaskRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.replicationTaskDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeReplicationTasksResponse.class).acceptors(DefaultDatabaseMigrationWaiter.replicationTaskDeletedWaiterAcceptors())).overrideConfiguration(DefaultDatabaseMigrationWaiter.replicationTaskDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeEndpointsResponse> waitUntilEndpointDeleted(DescribeEndpointsRequest describeEndpointsRequest) {
        return this.endpointDeletedWaiter.run(() -> this.client.describeEndpoints(this.applyWaitersUserAgent(describeEndpointsRequest)));
    }

    @Override
    public WaiterResponse<DescribeEndpointsResponse> waitUntilEndpointDeleted(DescribeEndpointsRequest describeEndpointsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.endpointDeletedWaiter.run(() -> this.client.describeEndpoints(this.applyWaitersUserAgent(describeEndpointsRequest)), DefaultDatabaseMigrationWaiter.endpointDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationInstancesResponse> waitUntilReplicationInstanceAvailable(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        return this.replicationInstanceAvailableWaiter.run(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationInstancesResponse> waitUntilReplicationInstanceAvailable(DescribeReplicationInstancesRequest describeReplicationInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationInstanceAvailableWaiter.run(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)), DefaultDatabaseMigrationWaiter.replicationInstanceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationInstancesResponse> waitUntilReplicationInstanceDeleted(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        return this.replicationInstanceDeletedWaiter.run(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationInstancesResponse> waitUntilReplicationInstanceDeleted(DescribeReplicationInstancesRequest describeReplicationInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationInstanceDeletedWaiter.run(() -> this.client.describeReplicationInstances(this.applyWaitersUserAgent(describeReplicationInstancesRequest)), DefaultDatabaseMigrationWaiter.replicationInstanceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskDeleted(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskDeletedWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskDeleted(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskDeletedWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationWaiter.replicationTaskDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskReady(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskReadyWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskReady(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskReadyWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationWaiter.replicationTaskReadyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskRunning(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskRunningWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskRunning(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskRunningWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationWaiter.replicationTaskRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskStopped(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return this.replicationTaskStoppedWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeReplicationTasksResponse> waitUntilReplicationTaskStopped(DescribeReplicationTasksRequest describeReplicationTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.replicationTaskStoppedWaiter.run(() -> this.client.describeReplicationTasks(this.applyWaitersUserAgent(describeReplicationTasksRequest)), DefaultDatabaseMigrationWaiter.replicationTaskStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConnectionsResponse> waitUntilTestConnectionSucceeds(DescribeConnectionsRequest describeConnectionsRequest) {
        return this.testConnectionSucceedsWaiter.run(() -> this.client.describeConnections(this.applyWaitersUserAgent(describeConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeConnectionsResponse> waitUntilTestConnectionSucceeds(DescribeConnectionsRequest describeConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.testConnectionSucceedsWaiter.run(() -> this.client.describeConnections(this.applyWaitersUserAgent(describeConnectionsRequest)), DefaultDatabaseMigrationWaiter.testConnectionSucceedsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeConnectionsResponse>> testConnectionSucceedsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Connections").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "successful"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Connections").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Connections[].Status=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEndpointsResponse>> endpointDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEndpointsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEndpointsResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDatabaseMigrationWaiter.errorCode(error), "ResourceNotFoundFault")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Endpoints").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "active"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Endpoints[].Status=active) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Endpoints").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Endpoints[].Status=creating) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> replicationInstanceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-credentials"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=incompatible-credentials) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-network"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=incompatible-network) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "inaccessible-encryption-credentials"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=inaccessible-encryption-credentials) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> replicationInstanceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationInstancesResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationInstances").flatten().field("ReplicationInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "available"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationInstances[].ReplicationInstanceStatus=available) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDatabaseMigrationWaiter.errorCode(error), "ResourceNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ready"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "starting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=starting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "running"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=running) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopped"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopped) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "testing"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=testing) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "stopped"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ready"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=ready) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "starting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=starting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "testing"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=testing) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ready"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=ready) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopped"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopped) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=modifying) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "testing"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=testing) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeReplicationTasksResponse>> replicationTaskDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeReplicationTasksResponse>>();
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ready"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=ready) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=creating) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopped"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=stopped) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "running"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=running) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ReplicationTasks").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ReplicationTasks[].Status=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDatabaseMigrationWaiter.errorCode(error), "ResourceNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration testConnectionSucceedsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration endpointDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationInstanceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationInstanceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration replicationTaskDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DatabaseMigrationWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DatabaseMigrationRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DatabaseMigrationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DatabaseMigrationWaiter.Builder {
        private DatabaseMigrationClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public DatabaseMigrationWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DatabaseMigrationWaiter.Builder client(DatabaseMigrationClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DatabaseMigrationWaiter build() {
            return new DefaultDatabaseMigrationWaiter(this);
        }
    }
}

