/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFleetAdvisorDatabasesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DeleteFleetAdvisorDatabasesResponse> {
    private static final SdkField<List<String>> DATABASE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseIds").getter(DeleteFleetAdvisorDatabasesResponse.getter(DeleteFleetAdvisorDatabasesResponse::databaseIds)).setter(DeleteFleetAdvisorDatabasesResponse.setter(Builder::databaseIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_IDS_FIELD));
    private final List<String> databaseIds;

    private DeleteFleetAdvisorDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databaseIds = builder.databaseIds;
    }

    public final boolean hasDatabaseIds() {
        return this.databaseIds != null && !(this.databaseIds instanceof SdkAutoConstructList);
    }

    public final List<String> databaseIds() {
        return this.databaseIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseIds() ? this.databaseIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFleetAdvisorDatabasesResponse)) {
            return false;
        }
        DeleteFleetAdvisorDatabasesResponse other = (DeleteFleetAdvisorDatabasesResponse)((Object)obj);
        return this.hasDatabaseIds() == other.hasDatabaseIds() && Objects.equals(this.databaseIds(), other.databaseIds());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFleetAdvisorDatabasesResponse").add("DatabaseIds", this.hasDatabaseIds() ? this.databaseIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseIds": {
                return Optional.ofNullable(clazz.cast(this.databaseIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFleetAdvisorDatabasesResponse, T> g) {
        return obj -> g.apply((DeleteFleetAdvisorDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<String> databaseIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFleetAdvisorDatabasesResponse model) {
            super(model);
            this.databaseIds(model.databaseIds);
        }

        public final Collection<String> getDatabaseIds() {
            if (this.databaseIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.databaseIds;
        }

        public final void setDatabaseIds(Collection<String> databaseIds) {
            this.databaseIds = StringListCopier.copy(databaseIds);
        }

        @Override
        public final Builder databaseIds(Collection<String> databaseIds) {
            this.databaseIds = StringListCopier.copy(databaseIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseIds(String ... databaseIds) {
            this.databaseIds(Arrays.asList(databaseIds));
            return this;
        }

        @Override
        public DeleteFleetAdvisorDatabasesResponse build() {
            return new DeleteFleetAdvisorDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFleetAdvisorDatabasesResponse> {
        public Builder databaseIds(Collection<String> var1);

        public Builder databaseIds(String ... var1);
    }
}

