/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;

public class DescribeEndpointSettingsIterable
implements SdkIterable<DescribeEndpointSettingsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeEndpointSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointSettingsIterable(DatabaseMigrationClient client, DescribeEndpointSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEndpointSettingsResponseFetcher();
    }

    public Iterator<DescribeEndpointSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeEndpointSettingsResponseFetcher
    implements SyncPageFetcher<DescribeEndpointSettingsResponse> {
        private DescribeEndpointSettingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEndpointSettingsResponse nextPage(DescribeEndpointSettingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointSettingsIterable.this.client.describeEndpointSettings(DescribeEndpointSettingsIterable.this.firstRequest);
            }
            return DescribeEndpointSettingsIterable.this.client.describeEndpointSettings((DescribeEndpointSettingsRequest)((Object)DescribeEndpointSettingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

