/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PluginNameValue {
    NO_PREFERENCE("no-preference"),
    TEST_DECODING("test-decoding"),
    PGLOGICAL("pglogical"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PluginNameValue> VALUE_MAP;
    private final String value;

    private PluginNameValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PluginNameValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PluginNameValue> knownValues() {
        EnumSet<PluginNameValue> knownValues = EnumSet.allOf(PluginNameValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PluginNameValue.class, PluginNameValue::toString);
    }
}

