/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse;

public class DescribeFleetAdvisorDatabasesIterable
implements SdkIterable<DescribeFleetAdvisorDatabasesResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeFleetAdvisorDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetAdvisorDatabasesIterable(DatabaseMigrationClient client, DescribeFleetAdvisorDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFleetAdvisorDatabasesResponseFetcher();
    }

    public Iterator<DescribeFleetAdvisorDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeFleetAdvisorDatabasesResponseFetcher
    implements SyncPageFetcher<DescribeFleetAdvisorDatabasesResponse> {
        private DescribeFleetAdvisorDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetAdvisorDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetAdvisorDatabasesResponse nextPage(DescribeFleetAdvisorDatabasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetAdvisorDatabasesIterable.this.client.describeFleetAdvisorDatabases(DescribeFleetAdvisorDatabasesIterable.this.firstRequest);
            }
            return DescribeFleetAdvisorDatabasesIterable.this.client.describeFleetAdvisorDatabases((DescribeFleetAdvisorDatabasesRequest)((Object)DescribeFleetAdvisorDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

