/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Fleet Advisor collector inventory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryData implements SdkPojo, Serializable, ToCopyableBuilder<InventoryData.Builder, InventoryData> {
    private static final SdkField<Integer> NUMBER_OF_DATABASES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDatabases").getter(getter(InventoryData::numberOfDatabases))
            .setter(setter(Builder::numberOfDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDatabases").build()).build();

    private static final SdkField<Integer> NUMBER_OF_SCHEMAS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfSchemas").getter(getter(InventoryData::numberOfSchemas))
            .setter(setter(Builder::numberOfSchemas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSchemas").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_DATABASES_FIELD,
            NUMBER_OF_SCHEMAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numberOfDatabases;

    private final Integer numberOfSchemas;

    private InventoryData(BuilderImpl builder) {
        this.numberOfDatabases = builder.numberOfDatabases;
        this.numberOfSchemas = builder.numberOfSchemas;
    }

    /**
     * <p>
     * The number of databases in the Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The number of databases in the Fleet Advisor collector inventory.
     */
    public final Integer numberOfDatabases() {
        return numberOfDatabases;
    }

    /**
     * <p>
     * The number of schemas in the Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The number of schemas in the Fleet Advisor collector inventory.
     */
    public final Integer numberOfSchemas() {
        return numberOfSchemas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSchemas());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryData)) {
            return false;
        }
        InventoryData other = (InventoryData) obj;
        return Objects.equals(numberOfDatabases(), other.numberOfDatabases())
                && Objects.equals(numberOfSchemas(), other.numberOfSchemas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryData").add("NumberOfDatabases", numberOfDatabases())
                .add("NumberOfSchemas", numberOfSchemas()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfDatabases":
            return Optional.ofNullable(clazz.cast(numberOfDatabases()));
        case "NumberOfSchemas":
            return Optional.ofNullable(clazz.cast(numberOfSchemas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryData, T> g) {
        return obj -> g.apply((InventoryData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryData> {
        /**
         * <p>
         * The number of databases in the Fleet Advisor collector inventory.
         * </p>
         * 
         * @param numberOfDatabases
         *        The number of databases in the Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDatabases(Integer numberOfDatabases);

        /**
         * <p>
         * The number of schemas in the Fleet Advisor collector inventory.
         * </p>
         * 
         * @param numberOfSchemas
         *        The number of schemas in the Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSchemas(Integer numberOfSchemas);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfDatabases;

        private Integer numberOfSchemas;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryData model) {
            numberOfDatabases(model.numberOfDatabases);
            numberOfSchemas(model.numberOfSchemas);
        }

        public final Integer getNumberOfDatabases() {
            return numberOfDatabases;
        }

        public final void setNumberOfDatabases(Integer numberOfDatabases) {
            this.numberOfDatabases = numberOfDatabases;
        }

        @Override
        public final Builder numberOfDatabases(Integer numberOfDatabases) {
            this.numberOfDatabases = numberOfDatabases;
            return this;
        }

        public final Integer getNumberOfSchemas() {
            return numberOfSchemas;
        }

        public final void setNumberOfSchemas(Integer numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
        }

        @Override
        public final Builder numberOfSchemas(Integer numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
            return this;
        }

        @Override
        public InventoryData build() {
            return new InventoryData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
