/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicableIndividualAssessmentsRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<DescribeApplicableIndividualAssessmentsRequest.Builder, DescribeApplicableIndividualAssessmentsRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(DescribeApplicableIndividualAssessmentsRequest::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn")
            .getter(getter(DescribeApplicableIndividualAssessmentsRequest::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> SOURCE_ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEngineName").getter(getter(DescribeApplicableIndividualAssessmentsRequest::sourceEngineName))
            .setter(setter(Builder::sourceEngineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngineName").build()).build();

    private static final SdkField<String> TARGET_ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEngineName").getter(getter(DescribeApplicableIndividualAssessmentsRequest::targetEngineName))
            .setter(setter(Builder::targetEngineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEngineName").build()).build();

    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationType").getter(getter(DescribeApplicableIndividualAssessmentsRequest::migrationTypeAsString))
            .setter(setter(Builder::migrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeApplicableIndividualAssessmentsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeApplicableIndividualAssessmentsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD,
            REPLICATION_INSTANCE_ARN_FIELD, SOURCE_ENGINE_NAME_FIELD, TARGET_ENGINE_NAME_FIELD, MIGRATION_TYPE_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String replicationTaskArn;

    private final String replicationInstanceArn;

    private final String sourceEngineName;

    private final String targetEngineName;

    private final String migrationType;

    private final Integer maxRecords;

    private final String marker;

    private DescribeApplicableIndividualAssessmentsRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.sourceEngineName = builder.sourceEngineName;
        this.targetEngineName = builder.targetEngineName;
        this.migrationType = builder.migrationType;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual
     * assessments.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual
     *         assessments.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * ARN of a replication instance on which you want to base the default list of individual assessments.
     * </p>
     * 
     * @return ARN of a replication instance on which you want to base the default list of individual assessments.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * Name of a database engine that the specified replication instance supports as a source.
     * </p>
     * 
     * @return Name of a database engine that the specified replication instance supports as a source.
     */
    public final String sourceEngineName() {
        return sourceEngineName;
    }

    /**
     * <p>
     * Name of a database engine that the specified replication instance supports as a target.
     * </p>
     * 
     * @return Name of a database engine that the specified replication instance supports as a target.
     */
    public final String targetEngineName() {
        return targetEngineName;
    }

    /**
     * <p>
     * Name of the migration type that each provided individual assessment must support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return Name of the migration type that each provided individual assessment must support.
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(migrationType);
    }

    /**
     * <p>
     * Name of the migration type that each provided individual assessment must support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #migrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #migrationTypeAsString}.
     * </p>
     * 
     * @return Name of the migration type that each provided individual assessment must support.
     * @see MigrationTypeValue
     */
    public final String migrationTypeAsString() {
        return migrationType;
    }

    /**
     * <p>
     * Maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
     * remaining results can be retrieved.
     * </p>
     * 
     * @return Maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
     *         remaining results can be retrieved.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * Optional pagination token provided by a previous request. If this parameter is specified, the response includes
     * only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return Optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEngineName());
        hashCode = 31 * hashCode + Objects.hashCode(targetEngineName());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicableIndividualAssessmentsRequest)) {
            return false;
        }
        DescribeApplicableIndividualAssessmentsRequest other = (DescribeApplicableIndividualAssessmentsRequest) obj;
        return Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(sourceEngineName(), other.sourceEngineName())
                && Objects.equals(targetEngineName(), other.targetEngineName())
                && Objects.equals(migrationTypeAsString(), other.migrationTypeAsString())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicableIndividualAssessmentsRequest").add("ReplicationTaskArn", replicationTaskArn())
                .add("ReplicationInstanceArn", replicationInstanceArn()).add("SourceEngineName", sourceEngineName())
                .add("TargetEngineName", targetEngineName()).add("MigrationType", migrationTypeAsString())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "SourceEngineName":
            return Optional.ofNullable(clazz.cast(sourceEngineName()));
        case "TargetEngineName":
            return Optional.ofNullable(clazz.cast(targetEngineName()));
        case "MigrationType":
            return Optional.ofNullable(clazz.cast(migrationTypeAsString()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicableIndividualAssessmentsRequest, T> g) {
        return obj -> g.apply((DescribeApplicableIndividualAssessmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicableIndividualAssessmentsRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of a migration task on which you want to base the default list of individual
         * assessments.
         * </p>
         * 
         * @param replicationTaskArn
         *        Amazon Resource Name (ARN) of a migration task on which you want to base the default list of
         *        individual assessments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * ARN of a replication instance on which you want to base the default list of individual assessments.
         * </p>
         * 
         * @param replicationInstanceArn
         *        ARN of a replication instance on which you want to base the default list of individual assessments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * Name of a database engine that the specified replication instance supports as a source.
         * </p>
         * 
         * @param sourceEngineName
         *        Name of a database engine that the specified replication instance supports as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEngineName(String sourceEngineName);

        /**
         * <p>
         * Name of a database engine that the specified replication instance supports as a target.
         * </p>
         * 
         * @param targetEngineName
         *        Name of a database engine that the specified replication instance supports as a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEngineName(String targetEngineName);

        /**
         * <p>
         * Name of the migration type that each provided individual assessment must support.
         * </p>
         * 
         * @param migrationType
         *        Name of the migration type that each provided individual assessment must support.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(String migrationType);

        /**
         * <p>
         * Name of the migration type that each provided individual assessment must support.
         * </p>
         * 
         * @param migrationType
         *        Name of the migration type that each provided individual assessment must support.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder migrationType(MigrationTypeValue migrationType);

        /**
         * <p>
         * Maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
         * remaining results can be retrieved.
         * </p>
         * 
         * @param maxRecords
         *        Maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * Optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        Optional pagination token provided by a previous request. If this parameter is specified, the response
         *        includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationTaskArn;

        private String replicationInstanceArn;

        private String sourceEngineName;

        private String targetEngineName;

        private String migrationType;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicableIndividualAssessmentsRequest model) {
            super(model);
            replicationTaskArn(model.replicationTaskArn);
            replicationInstanceArn(model.replicationInstanceArn);
            sourceEngineName(model.sourceEngineName);
            targetEngineName(model.targetEngineName);
            migrationType(model.migrationType);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final String getSourceEngineName() {
            return sourceEngineName;
        }

        public final void setSourceEngineName(String sourceEngineName) {
            this.sourceEngineName = sourceEngineName;
        }

        @Override
        public final Builder sourceEngineName(String sourceEngineName) {
            this.sourceEngineName = sourceEngineName;
            return this;
        }

        public final String getTargetEngineName() {
            return targetEngineName;
        }

        public final void setTargetEngineName(String targetEngineName) {
            this.targetEngineName = targetEngineName;
        }

        @Override
        public final Builder targetEngineName(String targetEngineName) {
            this.targetEngineName = targetEngineName;
            return this;
        }

        public final String getMigrationType() {
            return migrationType;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType == null ? null : migrationType.toString());
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicableIndividualAssessmentsRequest build() {
            return new DescribeApplicableIndividualAssessmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
