/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationConfigResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<CreateReplicationConfigResponse.Builder, CreateReplicationConfigResponse> {
    private static final SdkField<ReplicationConfig> REPLICATION_CONFIG_FIELD = SdkField
            .<ReplicationConfig> builder(MarshallingType.SDK_POJO).memberName("ReplicationConfig")
            .getter(getter(CreateReplicationConfigResponse::replicationConfig)).setter(setter(Builder::replicationConfig))
            .constructor(ReplicationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_FIELD));

    private final ReplicationConfig replicationConfig;

    private CreateReplicationConfigResponse(BuilderImpl builder) {
        super(builder);
        this.replicationConfig = builder.replicationConfig;
    }

    /**
     * <p>
     * Configuration parameters returned from the DMS Serverless replication after it is created.
     * </p>
     * 
     * @return Configuration parameters returned from the DMS Serverless replication after it is created.
     */
    public final ReplicationConfig replicationConfig() {
        return replicationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigResponse)) {
            return false;
        }
        CreateReplicationConfigResponse other = (CreateReplicationConfigResponse) obj;
        return Objects.equals(replicationConfig(), other.replicationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicationConfigResponse").add("ReplicationConfig", replicationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfig":
            return Optional.ofNullable(clazz.cast(replicationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigResponse, T> g) {
        return obj -> g.apply((CreateReplicationConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReplicationConfigResponse> {
        /**
         * <p>
         * Configuration parameters returned from the DMS Serverless replication after it is created.
         * </p>
         * 
         * @param replicationConfig
         *        Configuration parameters returned from the DMS Serverless replication after it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfig(ReplicationConfig replicationConfig);

        /**
         * <p>
         * Configuration parameters returned from the DMS Serverless replication after it is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationConfig.Builder} avoiding the
         * need to create one manually via {@link ReplicationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationConfig(ReplicationConfig)}.
         * 
         * @param replicationConfig
         *        a consumer that will call methods on {@link ReplicationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfig(ReplicationConfig)
         */
        default Builder replicationConfig(Consumer<ReplicationConfig.Builder> replicationConfig) {
            return replicationConfig(ReplicationConfig.builder().applyMutation(replicationConfig).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private ReplicationConfig replicationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigResponse model) {
            super(model);
            replicationConfig(model.replicationConfig);
        }

        public final ReplicationConfig.Builder getReplicationConfig() {
            return replicationConfig != null ? replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(ReplicationConfig.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        @Override
        public CreateReplicationConfigResponse build() {
            return new CreateReplicationConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
