/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParquetVersionValue {
    PARQUET_1_0("parquet-1-0"),
    PARQUET_2_0("parquet-2-0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParquetVersionValue> VALUE_MAP;
    private final String value;

    private ParquetVersionValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParquetVersionValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParquetVersionValue> knownValues() {
        EnumSet<ParquetVersionValue> knownValues = EnumSet.allOf(ParquetVersionValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParquetVersionValue.class, ParquetVersionValue::toString);
    }
}

