/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.NestingLevelValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocDbSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocDbSettings> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(DocDbSettings.getter(DocDbSettings::username)).setter(DocDbSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(DocDbSettings.getter(DocDbSettings::password)).setter(DocDbSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(DocDbSettings.getter(DocDbSettings::serverName)).setter(DocDbSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DocDbSettings.getter(DocDbSettings::port)).setter(DocDbSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DocDbSettings.getter(DocDbSettings::databaseName)).setter(DocDbSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> NESTING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NestingLevel").getter(DocDbSettings.getter(DocDbSettings::nestingLevelAsString)).setter(DocDbSettings.setter(Builder::nestingLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestingLevel").build()}).build();
    private static final SdkField<Boolean> EXTRACT_DOC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExtractDocId").getter(DocDbSettings.getter(DocDbSettings::extractDocId)).setter(DocDbSettings.setter(Builder::extractDocId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtractDocId").build()}).build();
    private static final SdkField<Integer> DOCS_TO_INVESTIGATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DocsToInvestigate").getter(DocDbSettings.getter(DocDbSettings::docsToInvestigate)).setter(DocDbSettings.setter(Builder::docsToInvestigate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocsToInvestigate").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DocDbSettings.getter(DocDbSettings::kmsKeyId)).setter(DocDbSettings.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(DocDbSettings.getter(DocDbSettings::secretsManagerAccessRoleArn)).setter(DocDbSettings.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(DocDbSettings.getter(DocDbSettings::secretsManagerSecretId)).setter(DocDbSettings.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, NESTING_LEVEL_FIELD, EXTRACT_DOC_ID_FIELD, DOCS_TO_INVESTIGATE_FIELD, KMS_KEY_ID_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String nestingLevel;
    private final Boolean extractDocId;
    private final Integer docsToInvestigate;
    private final String kmsKeyId;
    private final String secretsManagerAccessRoleArn;
    private final String secretsManagerSecretId;

    private DocDbSettings(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.nestingLevel = builder.nestingLevel;
        this.extractDocId = builder.extractDocId;
        this.docsToInvestigate = builder.docsToInvestigate;
        this.kmsKeyId = builder.kmsKeyId;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final NestingLevelValue nestingLevel() {
        return NestingLevelValue.fromValue(this.nestingLevel);
    }

    public final String nestingLevelAsString() {
        return this.nestingLevel;
    }

    public final Boolean extractDocId() {
        return this.extractDocId;
    }

    public final Integer docsToInvestigate() {
        return this.docsToInvestigate;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nestingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extractDocId());
        hashCode = 31 * hashCode + Objects.hashCode(this.docsToInvestigate());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocDbSettings)) {
            return false;
        }
        DocDbSettings other = (DocDbSettings)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.nestingLevelAsString(), other.nestingLevelAsString()) && Objects.equals(this.extractDocId(), other.extractDocId()) && Objects.equals(this.docsToInvestigate(), other.docsToInvestigate()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId());
    }

    public final String toString() {
        return ToString.builder((String)"DocDbSettings").add("Username", (Object)this.username()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("NestingLevel", (Object)this.nestingLevelAsString()).add("ExtractDocId", (Object)this.extractDocId()).add("DocsToInvestigate", (Object)this.docsToInvestigate()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "NestingLevel": {
                return Optional.ofNullable(clazz.cast(this.nestingLevelAsString()));
            }
            case "ExtractDocId": {
                return Optional.ofNullable(clazz.cast(this.extractDocId()));
            }
            case "DocsToInvestigate": {
                return Optional.ofNullable(clazz.cast(this.docsToInvestigate()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocDbSettings, T> g) {
        return obj -> g.apply((DocDbSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private String serverName;
        private Integer port;
        private String databaseName;
        private String nestingLevel;
        private Boolean extractDocId;
        private Integer docsToInvestigate;
        private String kmsKeyId;
        private String secretsManagerAccessRoleArn;
        private String secretsManagerSecretId;

        private BuilderImpl() {
        }

        private BuilderImpl(DocDbSettings model) {
            this.username(model.username);
            this.password(model.password);
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.nestingLevel(model.nestingLevel);
            this.extractDocId(model.extractDocId);
            this.docsToInvestigate(model.docsToInvestigate);
            this.kmsKeyId(model.kmsKeyId);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getNestingLevel() {
            return this.nestingLevel;
        }

        @Override
        public final Builder nestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
            return this;
        }

        @Override
        public final Builder nestingLevel(NestingLevelValue nestingLevel) {
            this.nestingLevel(nestingLevel == null ? null : nestingLevel.toString());
            return this;
        }

        public final void setNestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
        }

        public final Boolean getExtractDocId() {
            return this.extractDocId;
        }

        @Override
        public final Builder extractDocId(Boolean extractDocId) {
            this.extractDocId = extractDocId;
            return this;
        }

        public final void setExtractDocId(Boolean extractDocId) {
            this.extractDocId = extractDocId;
        }

        public final Integer getDocsToInvestigate() {
            return this.docsToInvestigate;
        }

        @Override
        public final Builder docsToInvestigate(Integer docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
            return this;
        }

        public final void setDocsToInvestigate(Integer docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        public DocDbSettings build() {
            return new DocDbSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocDbSettings> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder nestingLevel(String var1);

        public Builder nestingLevel(NestingLevelValue var1);

        public Builder extractDocId(Boolean var1);

        public Builder docsToInvestigate(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder secretsManagerSecretId(String var1);
    }
}

