/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTask;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationTasksResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationTasksResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationTasksResponse.getter(DescribeReplicationTasksResponse::marker)).setter(DescribeReplicationTasksResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationTask>> REPLICATION_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationTasks").getter(DescribeReplicationTasksResponse.getter(DescribeReplicationTasksResponse::replicationTasks)).setter(DescribeReplicationTasksResponse.setter(Builder::replicationTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_TASKS_FIELD));
    private final String marker;
    private final List<ReplicationTask> replicationTasks;

    private DescribeReplicationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationTasks = builder.replicationTasks;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasReplicationTasks() {
        return this.replicationTasks != null && !(this.replicationTasks instanceof SdkAutoConstructList);
    }

    public final List<ReplicationTask> replicationTasks() {
        return this.replicationTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationTasks() ? this.replicationTasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTasksResponse)) {
            return false;
        }
        DescribeReplicationTasksResponse other = (DescribeReplicationTasksResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplicationTasks() == other.hasReplicationTasks() && Objects.equals(this.replicationTasks(), other.replicationTasks());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationTasksResponse").add("Marker", (Object)this.marker()).add("ReplicationTasks", this.hasReplicationTasks() ? this.replicationTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationTasks": {
                return Optional.ofNullable(clazz.cast(this.replicationTasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTasksResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationTask> replicationTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTasksResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationTasks(model.replicationTasks);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReplicationTask.Builder> getReplicationTasks() {
            List<ReplicationTask.Builder> result = ReplicationTaskListCopier.copyToBuilder(this.replicationTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationTasks(Collection<ReplicationTask.BuilderImpl> replicationTasks) {
            this.replicationTasks = ReplicationTaskListCopier.copyFromBuilder(replicationTasks);
        }

        @Override
        @Transient
        public final Builder replicationTasks(Collection<ReplicationTask> replicationTasks) {
            this.replicationTasks = ReplicationTaskListCopier.copy(replicationTasks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationTasks(ReplicationTask ... replicationTasks) {
            this.replicationTasks(Arrays.asList(replicationTasks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationTasks(Consumer<ReplicationTask.Builder> ... replicationTasks) {
            this.replicationTasks(Stream.of(replicationTasks).map(c -> (ReplicationTask)((ReplicationTask.Builder)ReplicationTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationTasksResponse build() {
            return new DescribeReplicationTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationTasksResponse> {
        public Builder marker(String var1);

        public Builder replicationTasks(Collection<ReplicationTask> var1);

        public Builder replicationTasks(ReplicationTask ... var1);

        public Builder replicationTasks(Consumer<ReplicationTask.Builder> ... var1);
    }
}

