/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationException;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.InsufficientResourceCapacityException;
import software.amazon.awssdk.services.databasemigration.model.InvalidCertificateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidResourceStateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidSubnetException;
import software.amazon.awssdk.services.databasemigration.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.KmsDisabledException;
import software.amazon.awssdk.services.databasemigration.model.KmsException;
import software.amazon.awssdk.services.databasemigration.model.KmsInvalidStateException;
import software.amazon.awssdk.services.databasemigration.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.databasemigration.model.KmsNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.KmsThrottlingException;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.S3AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.S3ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.databasemigration.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpgradeDependencyFailureException;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable;
import software.amazon.awssdk.services.databasemigration.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CancelReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeApplicableIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointSettingsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointTypesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeOrderableReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRefreshSchemasStatusRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstanceTaskLogsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentResultsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTasksRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeTableStatisticsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ImportCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.MoveReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RebootReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RefreshSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReloadTablesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.TestConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDatabaseMigrationClient
implements DatabaseMigrationClient {
    private static final Logger log = Logger.loggerFor(DefaultDatabaseMigrationClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDatabaseMigrationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "dms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            AddTagsToResourceResponse addTagsToResourceResponse = (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$addTagsToResource$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApplyPendingMaintenanceActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyPendingMaintenanceAction");
            ApplyPendingMaintenanceActionResponse applyPendingMaintenanceActionResponse = (ApplyPendingMaintenanceActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyPendingMaintenanceActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return applyPendingMaintenanceActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$applyPendingMaintenanceAction$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelReplicationTaskAssessmentRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, cancelReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelReplicationTaskAssessmentRun");
            CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRunResponse = (CancelReplicationTaskAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelReplicationTaskAssessmentRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelReplicationTaskAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelReplicationTaskAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelReplicationTaskAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$cancelReplicationTaskAssessmentRun$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException, InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, createEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpoint");
            CreateEndpointResponse createEndpointResponse = (CreateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createEndpoint$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, createEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventSubscription");
            CreateEventSubscriptionResponse createEventSubscriptionResponse = (CreateEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createEventSubscription$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationInstanceResponse createReplicationInstance(CreateReplicationInstanceRequest createReplicationInstanceRequest) throws AccessDeniedException, ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException, StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, createReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationInstance");
            CreateReplicationInstanceResponse createReplicationInstanceResponse = (CreateReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationInstance$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationSubnetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, createReplicationSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationSubnetGroup");
            CreateReplicationSubnetGroupResponse createReplicationSubnetGroupResponse = (CreateReplicationSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationSubnetGroup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationTaskResponse createReplicationTask(CreateReplicationTaskRequest createReplicationTaskRequest) throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, createReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationTask");
            CreateReplicationTaskResponse createReplicationTaskResponse = (CreateReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationTask$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificate");
            DeleteCertificateResponse deleteCertificateResponse = (DeleteCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteCertificate$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            DeleteConnectionResponse deleteConnectionResponse = (DeleteConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteConnection$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            DeleteEndpointResponse deleteEndpointResponse = (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteEndpoint$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventSubscription");
            DeleteEventSubscriptionResponse deleteEventSubscriptionResponse = (DeleteEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteEventSubscription$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationInstanceResponse deleteReplicationInstance(DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationInstance");
            DeleteReplicationInstanceResponse deleteReplicationInstanceResponse = (DeleteReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationInstance$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationSubnetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationSubnetGroup");
            DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroupResponse = (DeleteReplicationSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationSubnetGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationTaskResponse deleteReplicationTask(DeleteReplicationTaskRequest deleteReplicationTaskRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationTask");
            DeleteReplicationTaskResponse deleteReplicationTaskResponse = (DeleteReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationTask$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationTaskAssessmentRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationTaskAssessmentRun");
            DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRunResponse = (DeleteReplicationTaskAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationTaskAssessmentRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationTaskAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationTaskAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationTaskAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationTaskAssessmentRun$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeAccountAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountAttributes");
            DescribeAccountAttributesResponse describeAccountAttributesResponse = (DescribeAccountAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeAccountAttributes$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicableIndividualAssessmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeApplicableIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicableIndividualAssessments");
            DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessmentsResponse = (DescribeApplicableIndividualAssessmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicableIndividualAssessments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeApplicableIndividualAssessmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicableIndividualAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicableIndividualAssessmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeApplicableIndividualAssessments$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeApplicableIndividualAssessmentsIterable describeApplicableIndividualAssessmentsPaginator(DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeApplicableIndividualAssessmentsIterable(this, this.applyPaginatorUserAgent(describeApplicableIndividualAssessmentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificates");
            DescribeCertificatesResponse describeCertificatesResponse = (DescribeCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeCertificates$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeCertificatesIterable describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeCertificatesIterable(this, this.applyPaginatorUserAgent(describeCertificatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnections");
            DescribeConnectionsResponse describeConnectionsResponse = (DescribeConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnections").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeConnections$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeConnectionsIterable describeConnectionsPaginator(DescribeConnectionsRequest describeConnectionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeConnectionsIterable(this, this.applyPaginatorUserAgent(describeConnectionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointSettingsResponse describeEndpointSettings(DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointSettings");
            DescribeEndpointSettingsResponse describeEndpointSettingsResponse = (DescribeEndpointSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEndpointSettings$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEndpointSettingsIterable describeEndpointSettingsPaginator(DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointSettingsIterable(this, this.applyPaginatorUserAgent(describeEndpointSettingsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointTypesResponse describeEndpointTypes(DescribeEndpointTypesRequest describeEndpointTypesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointTypes");
            DescribeEndpointTypesResponse describeEndpointTypesResponse = (DescribeEndpointTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEndpointTypes$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEndpointTypesIterable describeEndpointTypesPaginator(DescribeEndpointTypesRequest describeEndpointTypesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointTypesIterable(this, this.applyPaginatorUserAgent(describeEndpointTypesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEndpoints$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEndpointsIterable describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointsIterable(this, this.applyPaginatorUserAgent(describeEndpointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventCategoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            DescribeEventCategoriesResponse describeEventCategoriesResponse = (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventCategoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventCategoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEventCategories$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventSubscriptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeEventSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSubscriptions");
            DescribeEventSubscriptionsResponse describeEventSubscriptionsResponse = (DescribeEventSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEventSubscriptions$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEventSubscriptionsIterable(this, this.applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            DescribeEventsResponse describeEventsResponse = (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEvents$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrderableReplicationInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeOrderableReplicationInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableReplicationInstances");
            DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstancesResponse = (DescribeOrderableReplicationInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableReplicationInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrderableReplicationInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrderableReplicationInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrderableReplicationInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeOrderableReplicationInstances$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeOrderableReplicationInstancesIterable(this, this.applyPaginatorUserAgent(describeOrderableReplicationInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePendingMaintenanceActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingMaintenanceActions");
            DescribePendingMaintenanceActionsResponse describePendingMaintenanceActionsResponse = (DescribePendingMaintenanceActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingMaintenanceActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePendingMaintenanceActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describePendingMaintenanceActions$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribePendingMaintenanceActionsIterable(this, this.applyPaginatorUserAgent(describePendingMaintenanceActionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRefreshSchemasStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeRefreshSchemasStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRefreshSchemasStatus");
            DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatusResponse = (DescribeRefreshSchemasStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRefreshSchemasStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRefreshSchemasStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRefreshSchemasStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRefreshSchemasStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeRefreshSchemasStatus$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationInstanceTaskLogsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationInstanceTaskLogsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationInstanceTaskLogs");
            DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogsResponse = (DescribeReplicationInstanceTaskLogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationInstanceTaskLogs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationInstanceTaskLogsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationInstanceTaskLogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationInstanceTaskLogsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationInstanceTaskLogs$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationInstanceTaskLogsIterable describeReplicationInstanceTaskLogsPaginator(DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationInstanceTaskLogsIterable(this, this.applyPaginatorUserAgent(describeReplicationInstanceTaskLogsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationInstancesResponse describeReplicationInstances(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationInstances");
            DescribeReplicationInstancesResponse describeReplicationInstancesResponse = (DescribeReplicationInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationInstances$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationInstancesIterable describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationInstancesIterable(this, this.applyPaginatorUserAgent(describeReplicationInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationSubnetGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationSubnetGroups");
            DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroupsResponse = (DescribeReplicationSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationSubnetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationSubnetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationSubnetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationSubnetGroups$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeReplicationSubnetGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationTaskAssessmentResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTaskAssessmentResults");
            DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResultsResponse = (DescribeReplicationTaskAssessmentResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTaskAssessmentResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationTaskAssessmentResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTaskAssessmentResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTaskAssessmentResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTaskAssessmentResults$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationTaskAssessmentResultsIterable describeReplicationTaskAssessmentResultsPaginator(DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskAssessmentResultsIterable(this, this.applyPaginatorUserAgent(describeReplicationTaskAssessmentResultsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationTaskAssessmentRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTaskAssessmentRuns");
            DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRunsResponse = (DescribeReplicationTaskAssessmentRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTaskAssessmentRuns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationTaskAssessmentRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTaskAssessmentRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTaskAssessmentRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTaskAssessmentRuns$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationTaskAssessmentRunsIterable describeReplicationTaskAssessmentRunsPaginator(DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskAssessmentRunsIterable(this, this.applyPaginatorUserAgent(describeReplicationTaskAssessmentRunsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTaskIndividualAssessmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationTaskIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTaskIndividualAssessments");
            DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessmentsResponse = (DescribeReplicationTaskIndividualAssessmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTaskIndividualAssessments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationTaskIndividualAssessmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTaskIndividualAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTaskIndividualAssessmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTaskIndividualAssessments$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationTaskIndividualAssessmentsIterable describeReplicationTaskIndividualAssessmentsPaginator(DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskIndividualAssessmentsIterable(this, this.applyPaginatorUserAgent(describeReplicationTaskIndividualAssessmentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTasksResponse describeReplicationTasks(DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTasks");
            DescribeReplicationTasksResponse describeReplicationTasksResponse = (DescribeReplicationTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTasks$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationTasksIterable describeReplicationTasksPaginator(DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTasksIterable(this, this.applyPaginatorUserAgent(describeReplicationTasksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSchemasResponse describeSchemas(DescribeSchemasRequest describeSchemasRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSchemasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSchemas");
            DescribeSchemasResponse describeSchemasResponse = (DescribeSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchemas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeSchemas$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeSchemasIterable describeSchemasPaginator(DescribeSchemasRequest describeSchemasRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeSchemasIterable(this, this.applyPaginatorUserAgent(describeSchemasRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableStatisticsResponse describeTableStatistics(DescribeTableStatisticsRequest describeTableStatisticsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, describeTableStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableStatistics");
            DescribeTableStatisticsResponse describeTableStatisticsResponse = (DescribeTableStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTableStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeTableStatistics$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeTableStatisticsIterable describeTableStatisticsPaginator(DescribeTableStatisticsRequest describeTableStatisticsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeTableStatisticsIterable(this, this.applyPaginatorUserAgent(describeTableStatisticsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest) throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCertificateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, importCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCertificate");
            ImportCertificateResponse importCertificateResponse = (ImportCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCertificate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$importCertificate$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$listTagsForResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyEndpointResponse modifyEndpoint(ModifyEndpointRequest modifyEndpointRequest) throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException, KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, modifyEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEndpoint");
            ModifyEndpointResponse modifyEndpointResponse = (ModifyEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyEndpoint$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyEventSubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, modifyEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEventSubscription");
            ModifyEventSubscriptionResponse modifyEventSubscriptionResponse = (ModifyEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyEventSubscription$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationInstanceResponse modifyReplicationInstance(ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException, InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, modifyReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationInstance");
            ModifyReplicationInstanceResponse modifyReplicationInstanceResponse = (ModifyReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationInstance$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest modifyReplicationSubnetGroupRequest) throws AccessDeniedException, ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationSubnetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, modifyReplicationSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationSubnetGroup");
            ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroupResponse = (ModifyReplicationSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationSubnetGroup$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationTaskResponse modifyReplicationTask(ModifyReplicationTaskRequest modifyReplicationTaskRequest) throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, modifyReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationTask");
            ModifyReplicationTaskResponse modifyReplicationTaskResponse = (ModifyReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationTask$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MoveReplicationTaskResponse moveReplicationTask(MoveReplicationTaskRequest moveReplicationTaskRequest) throws AccessDeniedException, InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MoveReplicationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, moveReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MoveReplicationTask");
            MoveReplicationTaskResponse moveReplicationTaskResponse = (MoveReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MoveReplicationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)moveReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MoveReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return moveReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$moveReplicationTask$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootReplicationInstanceResponse rebootReplicationInstance(RebootReplicationInstanceRequest rebootReplicationInstanceRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootReplicationInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, rebootReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootReplicationInstance");
            RebootReplicationInstanceResponse rebootReplicationInstanceResponse = (RebootReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootReplicationInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$rebootReplicationInstance$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshSchemasResponse refreshSchemas(RefreshSchemasRequest refreshSchemasRequest) throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RefreshSchemasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, refreshSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RefreshSchemas");
            RefreshSchemasResponse refreshSchemasResponse = (RefreshSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RefreshSchemas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)refreshSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RefreshSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return refreshSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$refreshSchemas$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReloadTablesResponse reloadTables(ReloadTablesRequest reloadTablesRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReloadTablesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, reloadTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReloadTables");
            ReloadTablesResponse reloadTablesResponse = (ReloadTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReloadTables").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reloadTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReloadTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reloadTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$reloadTables$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            RemoveTagsFromResourceResponse removeTagsFromResourceResponse = (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$removeTagsFromResource$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReplicationTaskResponse startReplicationTask(StartReplicationTaskRequest startReplicationTaskRequest) throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReplicationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, startReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReplicationTask");
            StartReplicationTaskResponse startReplicationTaskResponse = (StartReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReplicationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$startReplicationTask$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReplicationTaskAssessmentResponse startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest startReplicationTaskAssessmentRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReplicationTaskAssessmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, startReplicationTaskAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReplicationTaskAssessment");
            StartReplicationTaskAssessmentResponse startReplicationTaskAssessmentResponse = (StartReplicationTaskAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReplicationTaskAssessment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startReplicationTaskAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReplicationTaskAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReplicationTaskAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$startReplicationTaskAssessment$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest startReplicationTaskAssessmentRunRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, KmsAccessDeniedException, KmsDisabledException, KmsException, KmsInvalidStateException, KmsNotFoundException, KmsKeyNotAccessibleException, S3AccessDeniedException, S3ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReplicationTaskAssessmentRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, startReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReplicationTaskAssessmentRun");
            StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRunResponse = (StartReplicationTaskAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReplicationTaskAssessmentRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startReplicationTaskAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReplicationTaskAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReplicationTaskAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$startReplicationTaskAssessmentRun$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopReplicationTaskResponse stopReplicationTask(StopReplicationTaskRequest stopReplicationTaskRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopReplicationTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, stopReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopReplicationTask");
            StopReplicationTaskResponse stopReplicationTaskResponse = (StopReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopReplicationTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$stopReplicationTask$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestConnectionResponse testConnection(TestConnectionRequest testConnectionRequest) throws ResourceNotFoundException, InvalidResourceStateException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(this.clientConfiguration, testConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestConnection");
            TestConnectionResponse testConnectionResponse = (TestConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$testConnection$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DatabaseMigrationException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").exceptionBuilderSupplier(KmsThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").exceptionBuilderSupplier(InvalidCertificateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").exceptionBuilderSupplier(KmsInvalidStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").exceptionBuilderSupplier(KmsNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").exceptionBuilderSupplier(S3AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").exceptionBuilderSupplier(KmsAccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSFault").exceptionBuilderSupplier(KmsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").exceptionBuilderSupplier(SnsInvalidTopicException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedFault").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").exceptionBuilderSupplier(InvalidResourceStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSDisabledFault").exceptionBuilderSupplier(KmsDisabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").exceptionBuilderSupplier(StorageQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends DatabaseMigrationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.35").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DatabaseMigrationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public DatabaseMigrationWaiter waiter() {
        return DatabaseMigrationWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$testConnection$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopReplicationTask$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReplicationTaskAssessmentRun$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReplicationTaskAssessment$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReplicationTask$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromResource$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$reloadTables$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$refreshSchemas$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootReplicationInstance$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$moveReplicationTask$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyReplicationTask$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyReplicationSubnetGroup$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyReplicationInstance$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyEventSubscription$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyEndpoint$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCertificate$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableStatistics$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSchemas$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationTasks$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationTaskIndividualAssessments$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationTaskAssessmentRuns$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationTaskAssessmentResults$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationSubnetGroups$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationInstances$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationInstanceTaskLogs$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRefreshSchemasStatus$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePendingMaintenanceActions$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrderableReplicationInstances$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventSubscriptions$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventCategories$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpointTypes$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpointSettings$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnections$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificates$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplicableIndividualAssessments$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountAttributes$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationTaskAssessmentRun$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationTask$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationSubnetGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationInstance$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventSubscription$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpoint$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnection$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificate$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationTask$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationSubnetGroup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationInstance$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventSubscription$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpoint$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelReplicationTaskAssessmentRun$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applyPendingMaintenanceAction$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToResource$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

