/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RedisAuthTypeValue {
    NONE("none"),
    AUTH_ROLE("auth-role"),
    AUTH_TOKEN("auth-token"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RedisAuthTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RedisAuthTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RedisAuthTypeValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RedisAuthTypeValue> knownValues() {
        return Stream.of(RedisAuthTypeValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

