/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.TableStatistics;
import software.amazon.awssdk.services.databasemigration.model.TableStatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableStatisticsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeTableStatisticsResponse> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(DescribeTableStatisticsResponse.getter(DescribeTableStatisticsResponse::replicationTaskArn)).setter(DescribeTableStatisticsResponse.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<List<TableStatistics>> TABLE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableStatistics").getter(DescribeTableStatisticsResponse.getter(DescribeTableStatisticsResponse::tableStatistics)).setter(DescribeTableStatisticsResponse.setter(Builder::tableStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTableStatisticsResponse.getter(DescribeTableStatisticsResponse::marker)).setter(DescribeTableStatisticsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, TABLE_STATISTICS_FIELD, MARKER_FIELD));
    private final String replicationTaskArn;
    private final List<TableStatistics> tableStatistics;
    private final String marker;

    private DescribeTableStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.tableStatistics = builder.tableStatistics;
        this.marker = builder.marker;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final boolean hasTableStatistics() {
        return this.tableStatistics != null && !(this.tableStatistics instanceof SdkAutoConstructList);
    }

    public final List<TableStatistics> tableStatistics() {
        return this.tableStatistics;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableStatistics() ? this.tableStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableStatisticsResponse)) {
            return false;
        }
        DescribeTableStatisticsResponse other = (DescribeTableStatisticsResponse)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && this.hasTableStatistics() == other.hasTableStatistics() && Objects.equals(this.tableStatistics(), other.tableStatistics()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTableStatisticsResponse").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("TableStatistics", this.hasTableStatistics() ? this.tableStatistics() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "TableStatistics": {
                return Optional.ofNullable(clazz.cast(this.tableStatistics()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableStatisticsResponse, T> g) {
        return obj -> g.apply((DescribeTableStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private List<TableStatistics> tableStatistics = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableStatisticsResponse model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.tableStatistics(model.tableStatistics);
            this.marker(model.marker);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final List<TableStatistics.Builder> getTableStatistics() {
            List<TableStatistics.Builder> result = TableStatisticsListCopier.copyToBuilder(this.tableStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableStatistics(Collection<TableStatistics.BuilderImpl> tableStatistics) {
            this.tableStatistics = TableStatisticsListCopier.copyFromBuilder(tableStatistics);
        }

        @Override
        @Transient
        public final Builder tableStatistics(Collection<TableStatistics> tableStatistics) {
            this.tableStatistics = TableStatisticsListCopier.copy(tableStatistics);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tableStatistics(TableStatistics ... tableStatistics) {
            this.tableStatistics(Arrays.asList(tableStatistics));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tableStatistics(Consumer<TableStatistics.Builder> ... tableStatistics) {
            this.tableStatistics(Stream.of(tableStatistics).map(c -> (TableStatistics)((TableStatistics.Builder)TableStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeTableStatisticsResponse build() {
            return new DescribeTableStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTableStatisticsResponse> {
        public Builder replicationTaskArn(String var1);

        public Builder tableStatistics(Collection<TableStatistics> var1);

        public Builder tableStatistics(TableStatistics ... var1);

        public Builder tableStatistics(Consumer<TableStatistics.Builder> ... var1);

        public Builder marker(String var1);
    }
}

