/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance;
import software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrderableReplicationInstancesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeOrderableReplicationInstancesResponse> {
    private static final SdkField<List<OrderableReplicationInstance>> ORDERABLE_REPLICATION_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderableReplicationInstances").getter(DescribeOrderableReplicationInstancesResponse.getter(DescribeOrderableReplicationInstancesResponse::orderableReplicationInstances)).setter(DescribeOrderableReplicationInstancesResponse.setter(Builder::orderableReplicationInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableReplicationInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderableReplicationInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeOrderableReplicationInstancesResponse.getter(DescribeOrderableReplicationInstancesResponse::marker)).setter(DescribeOrderableReplicationInstancesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERABLE_REPLICATION_INSTANCES_FIELD, MARKER_FIELD));
    private final List<OrderableReplicationInstance> orderableReplicationInstances;
    private final String marker;

    private DescribeOrderableReplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.orderableReplicationInstances = builder.orderableReplicationInstances;
        this.marker = builder.marker;
    }

    public final boolean hasOrderableReplicationInstances() {
        return this.orderableReplicationInstances != null && !(this.orderableReplicationInstances instanceof SdkAutoConstructList);
    }

    public final List<OrderableReplicationInstance> orderableReplicationInstances() {
        return this.orderableReplicationInstances;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderableReplicationInstances() ? this.orderableReplicationInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableReplicationInstancesResponse)) {
            return false;
        }
        DescribeOrderableReplicationInstancesResponse other = (DescribeOrderableReplicationInstancesResponse)((Object)obj);
        return this.hasOrderableReplicationInstances() == other.hasOrderableReplicationInstances() && Objects.equals(this.orderableReplicationInstances(), other.orderableReplicationInstances()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrderableReplicationInstancesResponse").add("OrderableReplicationInstances", this.hasOrderableReplicationInstances() ? this.orderableReplicationInstances() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableReplicationInstances": {
                return Optional.ofNullable(clazz.cast(this.orderableReplicationInstances()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableReplicationInstancesResponse, T> g) {
        return obj -> g.apply((DescribeOrderableReplicationInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<OrderableReplicationInstance> orderableReplicationInstances = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableReplicationInstancesResponse model) {
            super(model);
            this.orderableReplicationInstances(model.orderableReplicationInstances);
            this.marker(model.marker);
        }

        public final List<OrderableReplicationInstance.Builder> getOrderableReplicationInstances() {
            List<OrderableReplicationInstance.Builder> result = OrderableReplicationInstanceListCopier.copyToBuilder(this.orderableReplicationInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderableReplicationInstances(Collection<OrderableReplicationInstance.BuilderImpl> orderableReplicationInstances) {
            this.orderableReplicationInstances = OrderableReplicationInstanceListCopier.copyFromBuilder(orderableReplicationInstances);
        }

        @Override
        @Transient
        public final Builder orderableReplicationInstances(Collection<OrderableReplicationInstance> orderableReplicationInstances) {
            this.orderableReplicationInstances = OrderableReplicationInstanceListCopier.copy(orderableReplicationInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder orderableReplicationInstances(OrderableReplicationInstance ... orderableReplicationInstances) {
            this.orderableReplicationInstances(Arrays.asList(orderableReplicationInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder orderableReplicationInstances(Consumer<OrderableReplicationInstance.Builder> ... orderableReplicationInstances) {
            this.orderableReplicationInstances(Stream.of(orderableReplicationInstances).map(c -> (OrderableReplicationInstance)((OrderableReplicationInstance.Builder)OrderableReplicationInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeOrderableReplicationInstancesResponse build() {
            return new DescribeOrderableReplicationInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrderableReplicationInstancesResponse> {
        public Builder orderableReplicationInstances(Collection<OrderableReplicationInstance> var1);

        public Builder orderableReplicationInstances(OrderableReplicationInstance ... var1);

        public Builder orderableReplicationInstances(Consumer<OrderableReplicationInstance.Builder> ... var1);

        public Builder marker(String var1);
    }
}

