/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicableIndividualAssessmentsRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, DescribeApplicableIndividualAssessmentsRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::replicationTaskArn)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceArn").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::replicationInstanceArn)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<String> SOURCE_ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEngineName").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::sourceEngineName)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::sourceEngineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngineName").build()}).build();
    private static final SdkField<String> TARGET_ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEngineName").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::targetEngineName)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::targetEngineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEngineName").build()}).build();
    private static final SdkField<String> MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationType").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::migrationTypeAsString)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::migrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationType").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::maxRecords)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeApplicableIndividualAssessmentsRequest.getter(DescribeApplicableIndividualAssessmentsRequest::marker)).setter(DescribeApplicableIndividualAssessmentsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, REPLICATION_INSTANCE_ARN_FIELD, SOURCE_ENGINE_NAME_FIELD, TARGET_ENGINE_NAME_FIELD, MIGRATION_TYPE_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private final String replicationTaskArn;
    private final String replicationInstanceArn;
    private final String sourceEngineName;
    private final String targetEngineName;
    private final String migrationType;
    private final Integer maxRecords;
    private final String marker;

    private DescribeApplicableIndividualAssessmentsRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.sourceEngineName = builder.sourceEngineName;
        this.targetEngineName = builder.targetEngineName;
        this.migrationType = builder.migrationType;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public final String sourceEngineName() {
        return this.sourceEngineName;
    }

    public final String targetEngineName() {
        return this.targetEngineName;
    }

    public final MigrationTypeValue migrationType() {
        return MigrationTypeValue.fromValue(this.migrationType);
    }

    public final String migrationTypeAsString() {
        return this.migrationType;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEngineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicableIndividualAssessmentsRequest)) {
            return false;
        }
        DescribeApplicableIndividualAssessmentsRequest other = (DescribeApplicableIndividualAssessmentsRequest)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.sourceEngineName(), other.sourceEngineName()) && Objects.equals(this.targetEngineName(), other.targetEngineName()) && Objects.equals(this.migrationTypeAsString(), other.migrationTypeAsString()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicableIndividualAssessmentsRequest").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("SourceEngineName", (Object)this.sourceEngineName()).add("TargetEngineName", (Object)this.targetEngineName()).add("MigrationType", (Object)this.migrationTypeAsString()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "SourceEngineName": {
                return Optional.ofNullable(clazz.cast(this.sourceEngineName()));
            }
            case "TargetEngineName": {
                return Optional.ofNullable(clazz.cast(this.targetEngineName()));
            }
            case "MigrationType": {
                return Optional.ofNullable(clazz.cast(this.migrationTypeAsString()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicableIndividualAssessmentsRequest, T> g) {
        return obj -> g.apply((DescribeApplicableIndividualAssessmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private String replicationInstanceArn;
        private String sourceEngineName;
        private String targetEngineName;
        private String migrationType;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicableIndividualAssessmentsRequest model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.sourceEngineName(model.sourceEngineName);
            this.targetEngineName(model.targetEngineName);
            this.migrationType(model.migrationType);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getSourceEngineName() {
            return this.sourceEngineName;
        }

        @Override
        public final Builder sourceEngineName(String sourceEngineName) {
            this.sourceEngineName = sourceEngineName;
            return this;
        }

        public final void setSourceEngineName(String sourceEngineName) {
            this.sourceEngineName = sourceEngineName;
        }

        public final String getTargetEngineName() {
            return this.targetEngineName;
        }

        @Override
        public final Builder targetEngineName(String targetEngineName) {
            this.targetEngineName = targetEngineName;
            return this;
        }

        public final void setTargetEngineName(String targetEngineName) {
            this.targetEngineName = targetEngineName;
        }

        public final String getMigrationType() {
            return this.migrationType;
        }

        @Override
        public final Builder migrationType(String migrationType) {
            this.migrationType = migrationType;
            return this;
        }

        @Override
        public final Builder migrationType(MigrationTypeValue migrationType) {
            this.migrationType(migrationType == null ? null : migrationType.toString());
            return this;
        }

        public final void setMigrationType(String migrationType) {
            this.migrationType = migrationType;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicableIndividualAssessmentsRequest build() {
            return new DescribeApplicableIndividualAssessmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicableIndividualAssessmentsRequest> {
        public Builder replicationTaskArn(String var1);

        public Builder replicationInstanceArn(String var1);

        public Builder sourceEngineName(String var1);

        public Builder targetEngineName(String var1);

        public Builder migrationType(String var1);

        public Builder migrationType(MigrationTypeValue var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

