/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationTaskIndividualAssessmentsResponse extends DatabaseMigrationResponse
        implements
        ToCopyableBuilder<DescribeReplicationTaskIndividualAssessmentsResponse.Builder, DescribeReplicationTaskIndividualAssessmentsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationTaskIndividualAssessmentsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReplicationTaskIndividualAssessment>> REPLICATION_TASK_INDIVIDUAL_ASSESSMENTS_FIELD = SdkField
            .<List<ReplicationTaskIndividualAssessment>> builder(MarshallingType.LIST)
            .memberName("ReplicationTaskIndividualAssessments")
            .getter(getter(DescribeReplicationTaskIndividualAssessmentsResponse::replicationTaskIndividualAssessments))
            .setter(setter(Builder::replicationTaskIndividualAssessments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationTaskIndividualAssessments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationTaskIndividualAssessment> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationTaskIndividualAssessment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            REPLICATION_TASK_INDIVIDUAL_ASSESSMENTS_FIELD));

    private final String marker;

    private final List<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments;

    private DescribeReplicationTaskIndividualAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationTaskIndividualAssessments = builder.replicationTaskIndividualAssessments;
    }

    /**
     * <p>
     * A pagination token returned for you to pass to a subsequent request. If you pass this token as the
     * <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up to
     * the value specified in the request by <code>MaxRecords</code>.
     * </p>
     * 
     * @return A pagination token returned for you to pass to a subsequent request. If you pass this token as the
     *         <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker,
     *         up to the value specified in the request by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the ReplicationTaskIndividualAssessments property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasReplicationTaskIndividualAssessments() {
        return replicationTaskIndividualAssessments != null
                && !(replicationTaskIndividualAssessments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more individual assessments as specified by <code>Filters</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationTaskIndividualAssessments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more individual assessments as specified by <code>Filters</code>.
     */
    public final List<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments() {
        return replicationTaskIndividualAssessments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationTaskIndividualAssessments() ? replicationTaskIndividualAssessments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskIndividualAssessmentsResponse)) {
            return false;
        }
        DescribeReplicationTaskIndividualAssessmentsResponse other = (DescribeReplicationTaskIndividualAssessmentsResponse) obj;
        return Objects.equals(marker(), other.marker())
                && hasReplicationTaskIndividualAssessments() == other.hasReplicationTaskIndividualAssessments()
                && Objects.equals(replicationTaskIndividualAssessments(), other.replicationTaskIndividualAssessments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReplicationTaskIndividualAssessmentsResponse")
                .add("Marker", marker())
                .add("ReplicationTaskIndividualAssessments",
                        hasReplicationTaskIndividualAssessments() ? replicationTaskIndividualAssessments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReplicationTaskIndividualAssessments":
            return Optional.ofNullable(clazz.cast(replicationTaskIndividualAssessments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTaskIndividualAssessmentsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTaskIndividualAssessmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationTaskIndividualAssessmentsResponse> {
        /**
         * <p>
         * A pagination token returned for you to pass to a subsequent request. If you pass this token as the
         * <code>Marker</code> value in a subsequent request, the response includes only records beyond the marker, up
         * to the value specified in the request by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        A pagination token returned for you to pass to a subsequent request. If you pass this token as the
         *        <code>Marker</code> value in a subsequent request, the response includes only records beyond the
         *        marker, up to the value specified in the request by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * One or more individual assessments as specified by <code>Filters</code>.
         * </p>
         * 
         * @param replicationTaskIndividualAssessments
         *        One or more individual assessments as specified by <code>Filters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIndividualAssessments(
                Collection<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments);

        /**
         * <p>
         * One or more individual assessments as specified by <code>Filters</code>.
         * </p>
         * 
         * @param replicationTaskIndividualAssessments
         *        One or more individual assessments as specified by <code>Filters</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIndividualAssessments(ReplicationTaskIndividualAssessment... replicationTaskIndividualAssessments);

        /**
         * <p>
         * One or more individual assessments as specified by <code>Filters</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicationTaskIndividualAssessment>.Builder} avoiding the need to create one manually via {@link List
         * <ReplicationTaskIndividualAssessment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationTaskIndividualAssessment>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #replicationTaskIndividualAssessments(List<ReplicationTaskIndividualAssessment>)}.
         * 
         * @param replicationTaskIndividualAssessments
         *        a consumer that will call methods on {@link List<ReplicationTaskIndividualAssessment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTaskIndividualAssessments(List<ReplicationTaskIndividualAssessment>)
         */
        Builder replicationTaskIndividualAssessments(
                Consumer<ReplicationTaskIndividualAssessment.Builder>... replicationTaskIndividualAssessments);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskIndividualAssessmentsResponse model) {
            super(model);
            marker(model.marker);
            replicationTaskIndividualAssessments(model.replicationTaskIndividualAssessments);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationTaskIndividualAssessment.Builder> getReplicationTaskIndividualAssessments() {
            if (replicationTaskIndividualAssessments instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationTaskIndividualAssessments != null ? replicationTaskIndividualAssessments.stream()
                    .map(ReplicationTaskIndividualAssessment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationTaskIndividualAssessments(
                Collection<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments) {
            this.replicationTaskIndividualAssessments = ReplicationTaskIndividualAssessmentListCopier
                    .copy(replicationTaskIndividualAssessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskIndividualAssessments(
                ReplicationTaskIndividualAssessment... replicationTaskIndividualAssessments) {
            replicationTaskIndividualAssessments(Arrays.asList(replicationTaskIndividualAssessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskIndividualAssessments(
                Consumer<ReplicationTaskIndividualAssessment.Builder>... replicationTaskIndividualAssessments) {
            replicationTaskIndividualAssessments(Stream.of(replicationTaskIndividualAssessments)
                    .map(c -> ReplicationTaskIndividualAssessment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationTaskIndividualAssessments(
                Collection<ReplicationTaskIndividualAssessment.BuilderImpl> replicationTaskIndividualAssessments) {
            this.replicationTaskIndividualAssessments = ReplicationTaskIndividualAssessmentListCopier
                    .copyFromBuilder(replicationTaskIndividualAssessments);
        }

        @Override
        public DescribeReplicationTaskIndividualAssessmentsResponse build() {
            return new DescribeReplicationTaskIndividualAssessmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
