/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a quota for an AWS account, for example, the number of replication instances allowed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountQuota implements SdkPojo, Serializable, ToCopyableBuilder<AccountQuota.Builder, AccountQuota> {
    private static final SdkField<String> ACCOUNT_QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountQuotaName").getter(getter(AccountQuota::accountQuotaName))
            .setter(setter(Builder::accountQuotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountQuotaName").build()).build();

    private static final SdkField<Long> USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Used")
            .getter(getter(AccountQuota::used)).setter(setter(Builder::used))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()).build();

    private static final SdkField<Long> MAX_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Max")
            .getter(getter(AccountQuota::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_QUOTA_NAME_FIELD,
            USED_FIELD, MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountQuotaName;

    private final Long used;

    private final Long max;

    private AccountQuota(BuilderImpl builder) {
        this.accountQuotaName = builder.accountQuotaName;
        this.used = builder.used;
        this.max = builder.max;
    }

    /**
     * <p>
     * The name of the AWS DMS quota for this AWS account.
     * </p>
     * 
     * @return The name of the AWS DMS quota for this AWS account.
     */
    public final String accountQuotaName() {
        return accountQuotaName;
    }

    /**
     * <p>
     * The amount currently used toward the quota maximum.
     * </p>
     * 
     * @return The amount currently used toward the quota maximum.
     */
    public final Long used() {
        return used;
    }

    /**
     * <p>
     * The maximum allowed value for the quota.
     * </p>
     * 
     * @return The maximum allowed value for the quota.
     */
    public final Long max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountQuotaName());
        hashCode = 31 * hashCode + Objects.hashCode(used());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountQuota)) {
            return false;
        }
        AccountQuota other = (AccountQuota) obj;
        return Objects.equals(accountQuotaName(), other.accountQuotaName()) && Objects.equals(used(), other.used())
                && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountQuota").add("AccountQuotaName", accountQuotaName()).add("Used", used()).add("Max", max())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountQuotaName":
            return Optional.ofNullable(clazz.cast(accountQuotaName()));
        case "Used":
            return Optional.ofNullable(clazz.cast(used()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountQuota, T> g) {
        return obj -> g.apply((AccountQuota) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountQuota> {
        /**
         * <p>
         * The name of the AWS DMS quota for this AWS account.
         * </p>
         * 
         * @param accountQuotaName
         *        The name of the AWS DMS quota for this AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountQuotaName(String accountQuotaName);

        /**
         * <p>
         * The amount currently used toward the quota maximum.
         * </p>
         * 
         * @param used
         *        The amount currently used toward the quota maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder used(Long used);

        /**
         * <p>
         * The maximum allowed value for the quota.
         * </p>
         * 
         * @param max
         *        The maximum allowed value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Long max);
    }

    static final class BuilderImpl implements Builder {
        private String accountQuotaName;

        private Long used;

        private Long max;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountQuota model) {
            accountQuotaName(model.accountQuotaName);
            used(model.used);
            max(model.max);
        }

        public final String getAccountQuotaName() {
            return accountQuotaName;
        }

        @Override
        public final Builder accountQuotaName(String accountQuotaName) {
            this.accountQuotaName = accountQuotaName;
            return this;
        }

        public final void setAccountQuotaName(String accountQuotaName) {
            this.accountQuotaName = accountQuotaName;
        }

        public final Long getUsed() {
            return used;
        }

        @Override
        public final Builder used(Long used) {
            this.used = used;
            return this;
        }

        public final void setUsed(Long used) {
            this.used = used;
        }

        public final Long getMax() {
            return max;
        }

        @Override
        public final Builder max(Long max) {
            this.max = max;
            return this;
        }

        public final void setMax(Long max) {
            this.max = max;
        }

        @Override
        public AccountQuota build() {
            return new AccountQuota(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
