/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLogsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationInstanceTaskLogsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationInstanceTaskLogsResponse> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceArn").getter(DescribeReplicationInstanceTaskLogsResponse.getter(DescribeReplicationInstanceTaskLogsResponse::replicationInstanceArn)).setter(DescribeReplicationInstanceTaskLogsResponse.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<List<ReplicationInstanceTaskLog>> REPLICATION_INSTANCE_TASK_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInstanceTaskLogs").getter(DescribeReplicationInstanceTaskLogsResponse.getter(DescribeReplicationInstanceTaskLogsResponse::replicationInstanceTaskLogs)).setter(DescribeReplicationInstanceTaskLogsResponse.setter(Builder::replicationInstanceTaskLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceTaskLogs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationInstanceTaskLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationInstanceTaskLogsResponse.getter(DescribeReplicationInstanceTaskLogsResponse::marker)).setter(DescribeReplicationInstanceTaskLogsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_INSTANCE_ARN_FIELD, REPLICATION_INSTANCE_TASK_LOGS_FIELD, MARKER_FIELD));
    private final String replicationInstanceArn;
    private final List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs;
    private final String marker;

    private DescribeReplicationInstanceTaskLogsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.replicationInstanceTaskLogs = builder.replicationInstanceTaskLogs;
        this.marker = builder.marker;
    }

    public final String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public final boolean hasReplicationInstanceTaskLogs() {
        return this.replicationInstanceTaskLogs != null && !(this.replicationInstanceTaskLogs instanceof SdkAutoConstructList);
    }

    public final List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs() {
        return this.replicationInstanceTaskLogs;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInstanceTaskLogs() ? this.replicationInstanceTaskLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationInstanceTaskLogsResponse)) {
            return false;
        }
        DescribeReplicationInstanceTaskLogsResponse other = (DescribeReplicationInstanceTaskLogsResponse)((Object)obj);
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && this.hasReplicationInstanceTaskLogs() == other.hasReplicationInstanceTaskLogs() && Objects.equals(this.replicationInstanceTaskLogs(), other.replicationInstanceTaskLogs()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplicationInstanceTaskLogsResponse").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("ReplicationInstanceTaskLogs", this.hasReplicationInstanceTaskLogs() ? this.replicationInstanceTaskLogs() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "ReplicationInstanceTaskLogs": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceTaskLogs()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationInstanceTaskLogsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationInstanceTaskLogsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationInstanceTaskLogsResponse model) {
            super(model);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.replicationInstanceTaskLogs(model.replicationInstanceTaskLogs);
            this.marker(model.marker);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final Collection<ReplicationInstanceTaskLog.Builder> getReplicationInstanceTaskLogs() {
            if (this.replicationInstanceTaskLogs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationInstanceTaskLogs != null ? (Collection)this.replicationInstanceTaskLogs.stream().map(ReplicationInstanceTaskLog::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog> replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs = ReplicationInstanceTaskLogsListCopier.copy(replicationInstanceTaskLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceTaskLogs(ReplicationInstanceTaskLog ... replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs(Arrays.asList(replicationInstanceTaskLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceTaskLogs(Consumer<ReplicationInstanceTaskLog.Builder> ... replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs(Stream.of(replicationInstanceTaskLogs).map(c -> (ReplicationInstanceTaskLog)((ReplicationInstanceTaskLog.Builder)ReplicationInstanceTaskLog.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog.BuilderImpl> replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs = ReplicationInstanceTaskLogsListCopier.copyFromBuilder(replicationInstanceTaskLogs);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeReplicationInstanceTaskLogsResponse build() {
            return new DescribeReplicationInstanceTaskLogsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationInstanceTaskLogsResponse> {
        public Builder replicationInstanceArn(String var1);

        public Builder replicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog> var1);

        public Builder replicationInstanceTaskLogs(ReplicationInstanceTaskLog ... var1);

        public Builder replicationInstanceTaskLogs(Consumer<ReplicationInstanceTaskLog.Builder> ... var1);

        public Builder marker(String var1);
    }
}

