/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;

public class DescribeReplicationSubnetGroupsIterable
implements SdkIterable<DescribeReplicationSubnetGroupsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationSubnetGroupsIterable(DatabaseMigrationClient client, DescribeReplicationSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReplicationSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeReplicationSubnetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReplicationSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationSubnetGroupsResponse> {
        private DescribeReplicationSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationSubnetGroupsResponse nextPage(DescribeReplicationSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationSubnetGroupsIterable.this.client.describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeReplicationSubnetGroupsIterable.this.client.describeReplicationSubnetGroups((DescribeReplicationSubnetGroupsRequest)((Object)DescribeReplicationSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

