/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;

public class DescribeConnectionsIterable
implements SdkIterable<DescribeConnectionsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConnectionsIterable(DatabaseMigrationClient client, DescribeConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeConnectionsResponseFetcher();
    }

    public Iterator<DescribeConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeConnectionsIterable resume(DescribeConnectionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeConnectionsIterable(this.client, (DescribeConnectionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeConnectionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeConnectionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeConnectionsResponse> {
        private DescribeConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeConnectionsResponse nextPage(DescribeConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConnectionsIterable.this.client.describeConnections(DescribeConnectionsIterable.this.firstRequest);
            }
            return DescribeConnectionsIterable.this.client.describeConnections((DescribeConnectionsRequest)((Object)DescribeConnectionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

