/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.TableToReload;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TableToReloadMarshaller {
    private static final MarshallingInfo<String> SCHEMANAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final TableToReloadMarshaller INSTANCE = new TableToReloadMarshaller();

    private TableToReloadMarshaller() {
    }

    public static TableToReloadMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TableToReload tableToReload, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tableToReload, (String)"tableToReload");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tableToReload.schemaName(), SCHEMANAME_BINDING);
            protocolMarshaller.marshall((Object)tableToReload.tableName(), TABLENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

