/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.S3Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3SettingsMarshaller {
    private static final MarshallingInfo<String> SERVICEACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALTABLEDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalTableDefinition").isBinary(false).build();
    private static final MarshallingInfo<String> CSVROWDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CsvRowDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> CSVDELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CsvDelimiter").isBinary(false).build();
    private static final MarshallingInfo<String> BUCKETFOLDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketFolder").isBinary(false).build();
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompressionType").isBinary(false).build();
    private static final S3SettingsMarshaller INSTANCE = new S3SettingsMarshaller();

    private S3SettingsMarshaller() {
    }

    public static S3SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Settings s3Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Settings, (String)"s3Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Settings.serviceAccessRoleArn(), SERVICEACCESSROLEARN_BINDING);
            protocolMarshaller.marshall((Object)s3Settings.externalTableDefinition(), EXTERNALTABLEDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)s3Settings.csvRowDelimiter(), CSVROWDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)s3Settings.csvDelimiter(), CSVDELIMITER_BINDING);
            protocolMarshaller.marshall((Object)s3Settings.bucketFolder(), BUCKETFOLDER_BINDING);
            protocolMarshaller.marshall((Object)s3Settings.bucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Settings.compressionTypeAsString(), COMPRESSIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

