/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationSubnetGroupMarshaller {
    private static final MarshallingInfo<String> REPLICATIONSUBNETGROUPIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationSubnetGroupIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICATIONSUBNETGROUPDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicationSubnetGroupDescription").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETGROUPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupStatus").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").isBinary(false).build();
    private static final ReplicationSubnetGroupMarshaller INSTANCE = new ReplicationSubnetGroupMarshaller();

    private ReplicationSubnetGroupMarshaller() {
    }

    public static ReplicationSubnetGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationSubnetGroup replicationSubnetGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationSubnetGroup, (String)"replicationSubnetGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationSubnetGroup.replicationSubnetGroupIdentifier(), REPLICATIONSUBNETGROUPIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)replicationSubnetGroup.replicationSubnetGroupDescription(), REPLICATIONSUBNETGROUPDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)replicationSubnetGroup.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall((Object)replicationSubnetGroup.subnetGroupStatus(), SUBNETGROUPSTATUS_BINDING);
            protocolMarshaller.marshall(replicationSubnetGroup.subnets(), SUBNETS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

