/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeEventsRequestModelMarshaller {
    private static final MarshallingInfo<String> SOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTCATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCategories").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRecords").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final DescribeEventsRequestModelMarshaller INSTANCE = new DescribeEventsRequestModelMarshaller();

    private DescribeEventsRequestModelMarshaller() {
    }

    public static DescribeEventsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeEventsRequest describeEventsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeEventsRequest), (String)"describeEventsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeEventsRequest.sourceIdentifier(), SOURCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)describeEventsRequest.sourceTypeAsString(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)describeEventsRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)describeEventsRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)describeEventsRequest.duration(), DURATION_BINDING);
            protocolMarshaller.marshall(describeEventsRequest.eventCategories(), EVENTCATEGORIES_BINDING);
            protocolMarshaller.marshall(describeEventsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)describeEventsRequest.maxRecords(), MAXRECORDS_BINDING);
            protocolMarshaller.marshall((Object)describeEventsRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

